/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.TokenGenerationException;
import org.glite.sts.ta.TokenGenerator;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidProfileContext")})
public class IssueCertificate
extends AbstractProfileAction<Object, Object> {
    private final Logger log = LoggerFactory.getLogger(IssueCertificate.class);
    private Function<MessageContext<?>, TokenGenerationContext> tokenGenerationContextLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);
    private TokenGenerator tokenGenerator;

    public IssueCertificate() {
    }

    public IssueCertificate(X509TokenGenerator x509TokenGenerator) {
        this();
        this.tokenGenerator = x509TokenGenerator;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Object> profileRequestContext) throws ProfileException {
        TokenGenerationContext tokenGenerationContext = (TokenGenerationContext)((Object)this.tokenGenerationContextLookupStrategy.apply((Object)profileRequestContext.getOutboundMessageContext()));
        if (tokenGenerationContext == null) {
            this.log.debug("Action {}: Token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        X509TokenGenerationContext x509TokenGenerationContext = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)tokenGenerationContext));
        if (x509TokenGenerationContext == null) {
            this.log.debug("Action {}: X.509 token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        try {
            this.tokenGenerator.issueToken(tokenGenerationContext);
        }
        catch (TokenGenerationException e) {
            this.log.error("Could not issue a certificate", (Throwable)e);
            throw new CertificateIssuanceException((Throwable)e);
        }
        if (x509TokenGenerationContext.getCaResponse() == null || x509TokenGenerationContext.getCaResponse().getCertificate() == null) {
            this.log.debug("Action {}: Could not obtain a certificate from the online CA", (Object)this.getId());
            throw new CertificateIssuanceException("The online CA could not issue a certificate");
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class CertificateIssuanceException
    extends ProfileException {
        private static final long serialVersionUID = -872917442222234555L;

        public CertificateIssuanceException(Throwable e) {
            super(e.getMessage());
        }

        public CertificateIssuanceException(String message) {
            super(message);
        }
    }
}

