/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.STSException;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.RSACertificateKeys;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class InitializeX509TokenGenerationContext
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(InitializeX509TokenGenerationContext.class);
    private Function<MessageContext<Envelope>, TokenGenerationContext> tokenGenerationCtxLookupStrategy;
    private int keysize;

    public InitializeX509TokenGenerationContext(int strength) {
        this.keysize = strength;
        this.tokenGenerationCtxLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        RSACertificateKeys keys;
        MessageContext outMessageContext;
        MessageContext inMessageContext = profileRequestContext.getInboundMessageContext();
        if (inMessageContext == null) {
            this.log.debug("Action {}: inbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        if ((outMessageContext = profileRequestContext.getOutboundMessageContext()) == null) {
            this.log.debug("Action {}: outbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        TokenGenerationContext tokenGenerationContext = (TokenGenerationContext)((Object)this.tokenGenerationCtxLookupStrategy.apply((Object)outMessageContext));
        X509TokenGenerationContext x509tokenGenerationContext = new X509TokenGenerationContext();
        RSAPublicKey publicKey = tokenGenerationContext.getTokenType().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-tokenprofile-1.0#X509v3") ? SoapActionSupport.getPublicKeyFromEnvelope(this, (Envelope)inMessageContext.getMessage()) : null;
        try {
            if (publicKey != null) {
                this.log.debug("Action {}: using the public key from the request message", (Object)this.getId());
                keys = new RSACertificateKeys(publicKey);
            } else {
                this.log.debug("Action {}: generating a new key-pair of {} bits", (Object)this.getId(), (Object)this.keysize);
                keys = new RSACertificateKeys(this.keysize);
            }
        }
        catch (STSException e) {
            this.log.error("Action {}: Could not generate a key-pair", (Object)this.getId(), (Object)e);
            throw new ProfileException("Could not generate a key-pair", e);
        }
        x509tokenGenerationContext.setCertKeys(keys);
        tokenGenerationContext.addSubcontext(x509tokenGenerationContext);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

