/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.Reference;
import org.opensaml.soap.wssecurity.SecurityTokenReference;
import org.opensaml.soap.wstrust.Claims;
import org.opensaml.soap.wstrust.RequestSecurityToken;
import org.opensaml.soap.wstrust.RequestType;
import org.opensaml.soap.wstrust.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class InitializeTokenRequestMessageContext
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(InitializeTokenRequestMessageContext.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        Envelope envelope = (Envelope)messageContext.getMessage();
        Body body = envelope.getBody();
        if (body == null) {
            this.log.error("Action {}: Body was not found from the envelope!", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        RequestSecurityToken rst = this.getRequestSecurityTokenFromBody(body);
        TokenRequestMessageContext tokenRequestCtx = new TokenRequestMessageContext();
        tokenRequestCtx.setId(this.getIdFromRequestSecurityToken(rst));
        tokenRequestCtx.setContext(rst.getContext());
        tokenRequestCtx.setAction(this.getRequestTypeFromRequestSecurityToken(rst));
        tokenRequestCtx.setTokenType(this.getTokenTypeFromRequestSecurityToken(rst));
        Claims claims = this.getClaimsFromRequestSecurityToken(rst);
        tokenRequestCtx.setClaimsDialect(claims.getDialect());
        tokenRequestCtx.setTokenReference(this.getTokenReferenceUriFromClaims(claims));
        messageContext.addSubcontext((BaseContext)tokenRequestCtx);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected RequestSecurityToken getRequestSecurityTokenFromBody(Body body) throws ProfileException {
        List objects = body.getUnknownXMLObjects(RequestSecurityToken.ELEMENT_NAME);
        if (objects.size() == 1) {
            return (RequestSecurityToken)objects.get(0);
        }
        throw new ProfileException("No single RequestSecurityToken -element found from the envelope body!");
    }

    protected String getIdFromRequestSecurityToken(RequestSecurityToken rst) {
        return rst.getUnknownAttributes().get((Object)IdBearing.WSU_ID_ATTR_NAME);
    }

    protected String getRequestTypeFromRequestSecurityToken(RequestSecurityToken rst) throws ProfileException {
        List objects = rst.getUnknownXMLObjects(RequestType.ELEMENT_NAME);
        if (objects.size() == 1) {
            RequestType requestType = (RequestType)objects.get(0);
            return requestType.getValue();
        }
        throw new ProfileException("No single RequestType element found from the RST!");
    }

    protected String getTokenTypeFromRequestSecurityToken(RequestSecurityToken rst) throws ProfileException {
        List objects = rst.getUnknownXMLObjects(TokenType.ELEMENT_NAME);
        if (objects.size() == 1) {
            TokenType tokenType = (TokenType)objects.get(0);
            return tokenType.getValue();
        }
        throw new ProfileException("No single TokenType element found from the RST!");
    }

    protected Claims getClaimsFromRequestSecurityToken(RequestSecurityToken rst) throws ProfileException {
        List objects = rst.getUnknownXMLObjects(Claims.ELEMENT_NAME);
        if (objects.size() == 1) {
            return (Claims)objects.get(0);
        }
        throw new ProfileException("No single Claims element found from the RST!");
    }

    protected String getTokenReferenceUriFromClaims(Claims claims) throws ProfileException {
        List objects = claims.getUnknownXMLObjects(SecurityTokenReference.ELEMENT_NAME);
        if (objects.size() == 1) {
            SecurityTokenReference tokenReference = (SecurityTokenReference)objects.get(0);
            if ((objects = tokenReference.getUnknownXMLObjects(Reference.ELEMENT_NAME)).size() == 1) {
                Reference reference = (Reference)objects.get(0);
                return reference.getURI();
            }
            throw new ProfileException("No single Reference element found from the SecurityTokenReference!");
        }
        throw new ProfileException("No single SecurityTokenReference element found from the Claims!");
    }
}

