/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.glite.sts.profile.config.WsTrustInteroperabilityProfileConfiguration;
import org.opensaml.messaging.context.MessageContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitializeProfile
extends AbstractIdentifiableInitializableComponent
implements Action,
IdentifiableComponent {
    private String rpContextId;
    private String rpConfigurationId;
    private String rpResponderId;
    private int clockSkew;

    public InitializeProfile(String contextId, String configurationId, String responderId, int skew) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.rpContextId = (String)Constraint.isNotNull((Object)contextId, (String)"Relying party context id cannot be null!");
        this.rpConfigurationId = (String)Constraint.isNotNull((Object)configurationId, (String)"Relying party configuration id cannot be null!");
        this.rpResponderId = (String)Constraint.isNotNull((Object)responderId, (String)"Relying party responder id cannot be null!");
        this.clockSkew = (int)Constraint.isGreaterThan((long)0L, (long)skew, (String)"Clock skew cannot be zero!");
    }

    public Event execute(RequestContext springRequestContext) throws Exception {
        ProfileRequestContext profileContext = new ProfileRequestContext();
        profileContext.setOutboundMessageContext(new MessageContext());
        RelyingPartyContext rpCtx = new RelyingPartyContext(this.rpContextId);
        profileContext.addSubcontext(rpCtx);
        rpCtx.setProfileConfiguration(InitializeProfile.buildProfileConfiguration(this.clockSkew));
        rpCtx.setRelyingPartyConfiguration(new RelyingPartyConfiguration(this.rpConfigurationId, this.rpResponderId, InitializeProfile.buildProfileConfigurations(this.clockSkew)));
        springRequestContext.getConversationScope().put(ProfileRequestContext.BINDING_KEY, profileContext);
        return ActionSupport.buildProceedEvent(this);
    }

    public static Collection<ProfileConfiguration> buildProfileConfigurations(int clockSkew) {
        ArrayList<ProfileConfiguration> profileConfigs = new ArrayList<ProfileConfiguration>();
        profileConfigs.add(InitializeProfile.buildProfileConfiguration(clockSkew));
        return profileConfigs;
    }

    public static WsTrustInteroperabilityProfileConfiguration buildProfileConfiguration(int clockSkew) {
        SecurityConfiguration securityConfig = new SecurityConfiguration(clockSkew, (IdentifierGenerationStrategy)new RandomIdentifierGenerationStrategy());
        WsTrustInteroperabilityProfileConfiguration wsTrustConfig = new WsTrustInteroperabilityProfileConfiguration();
        wsTrustConfig.setSecurityConfiguration(securityConfig);
        return wsTrustConfig;
    }
}

