/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitializeMessageMetadataContext
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(InitializeMessageMetadataContext.class);

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        BasicMessageMetadataContext messageMetadata = new BasicMessageMetadataContext();
        Header header = ((Envelope)messageContext.getMessage()).getHeader();
        if (header == null) {
            this.log.debug("Action {}: Could not find the Envelope header!", (Object)this.getId());
            throw new ProfileException("Header was not found from the envelope!");
        }
        this.log.debug("Action {}: Looking for creation timestamp from the envelope header", (Object)this.getId());
        long created = this.getCreatedFromHeader(header);
        this.log.debug("Action {}: Looking for message ID from the envelope header", (Object)this.getId());
        String messageID = this.getMessageIDFromHeader(header);
        messageMetadata.setMessageIssueInstant(created);
        messageMetadata.setMessageId(messageID);
        messageContext.addSubcontext((BaseContext)messageMetadata, true);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected long getCreatedFromHeader(Header header) throws ProfileException {
        Timestamp timestamp;
        Created created;
        Security security;
        List objects = header.getUnknownXMLObjects(Security.ELEMENT_NAME);
        if (objects.size() == 1 && (objects = (security = (Security)objects.get(0)).getUnknownXMLObjects(Timestamp.ELEMENT_NAME)).size() == 1 && (created = (timestamp = (Timestamp)objects.get(0)).getCreated()) != null) {
            this.log.debug("Action {}: Found creation timestamp: {}", (Object)this.getId(), (Object)created.getDateTime().toString());
            return created.getDateTime().getMillis();
        }
        this.log.debug("Action {}: Could not find a timestamp from the envelope header", (Object)this.getId());
        return 0L;
    }

    protected String getMessageIDFromHeader(Header header) throws ProfileException {
        List objects = header.getUnknownXMLObjects(MessageID.ELEMENT_NAME);
        if (objects.size() == 1) {
            MessageID messageId = (MessageID)objects.get(0);
            this.log.debug("Action {}: Found message ID {}", (Object)this.getId(), (Object)messageId.getValue());
            return messageId.getValue();
        }
        this.log.debug("Action {}: Could not find a message ID from the header", (Object)this.getId());
        return null;
    }
}

