/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXmlMessageDecoder;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EnvelopeDecoder
extends BaseHttpServletRequestXmlMessageDecoder<Envelope> {
    private final Logger log = LoggerFactory.getLogger(EnvelopeDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        Envelope envelope;
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        this.log.debug("Obtaining the parser pool");
        ParserPool parserPool = this.getParserPool();
        this.log.debug("Attempting to parse the servlet request into an Envelope");
        try {
            Document document = parserPool.parse((InputStream)httpRequest.getInputStream());
            Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(Envelope.DEFAULT_ELEMENT_NAME);
            envelope = (Envelope)unmarshaller.unmarshall(document.getDocumentElement());
        }
        catch (Exception e) {
            this.log.debug("Could not parse the request into an Envelope", (Throwable)e);
            throw new MessageDecodingException("Could not parse the request into an Envelope", e);
        }
        this.log.debug("Parsing was successful, now attaching it into the message context");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)envelope);
        this.setMessageContext(messageContext);
    }
}

