/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.attribute.AttributeContext;
import net.shibboleth.idp.attribute.AttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.authn.AssertionContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class DecodeAttributesFromAssertion
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(DecodeAttributesFromAssertion.class);
    private Function<ProfileRequestContext<Envelope, Envelope>, AuthenticationRequestContext> authnCtxLookupStrategy = new ChildContextLookup(AuthenticationRequestContext.class, false);
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outMessageContext;
        MessageContext inMessageContext = profileRequestContext.getInboundMessageContext();
        if (inMessageContext == null) {
            this.log.debug("Action {}: inbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        if ((outMessageContext = profileRequestContext.getOutboundMessageContext()) == null) {
            this.log.debug("Action {}: outbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        AuthenticationRequestContext authnContext = (AuthenticationRequestContext)((Object)this.authnCtxLookupStrategy.apply(profileRequestContext));
        AssertionContext assertionContext = (AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authnContext));
        AttributeContext attributeContext = new AttributeContext();
        attributeContext.setAttributes(this.getAttributesFromAssertion(assertionContext.getAssertion()));
        profileRequestContext.addSubcontext(attributeContext, false);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected List<net.shibboleth.idp.attribute.Attribute> getAttributesFromAssertion(Assertion assertion) throws ProfileException {
        Vector<net.shibboleth.idp.attribute.Attribute> attributes = new Vector<net.shibboleth.idp.attribute.Attribute>();
        List statements = assertion.getAttributeStatements();
        for (int i = 0; i < statements.size(); ++i) {
            List samlAttributes = ((AttributeStatement)statements.get(i)).getAttributes();
            for (int j = 0; j < samlAttributes.size(); ++j) {
                attributes.add(this.generateAttribute((Attribute)samlAttributes.get(j)));
            }
        }
        return attributes;
    }

    protected net.shibboleth.idp.attribute.Attribute generateAttribute(Attribute samlAttribute) throws ProfileException {
        String attributeId = samlAttribute.getFriendlyName();
        if (attributeId == null) {
            attributeId = samlAttribute.getName();
        }
        net.shibboleth.idp.attribute.Attribute attribute = new net.shibboleth.idp.attribute.Attribute(attributeId);
        this.log.debug("Action {}: Adding an attribute {}", (Object)this.getId(), (Object)attributeId);
        StringAttributeValue attrValue = this.getSamlAttributeValue(samlAttribute);
        Vector<AttributeValue> list = new Vector<AttributeValue>();
        list.add(attrValue);
        attribute.setValues(list);
        return attribute;
    }

    protected StringAttributeValue getSamlAttributeValue(Attribute samlAttribute) throws ProfileException {
        String stringValue;
        XMLObject samlValue = (XMLObject)samlAttribute.getAttributeValues().get(0);
        if (samlValue instanceof XSString) {
            stringValue = ((XSString)samlValue).getValue();
        } else if (samlValue instanceof XSAny) {
            stringValue = ((XSAny)samlValue).getTextContent();
        } else {
            throw new UnSupportedAttributeValueTypeException(samlValue.getClass().toString());
        }
        return new StringAttributeValue(stringValue);
    }

    public static class UnSupportedAttributeValueTypeException
    extends ProfileException {
        private static final long serialVersionUID = -7234512349423732050L;

        public UnSupportedAttributeValueTypeException(String type) {
            super("Un-supported attribute value type: " + type);
        }
    }
}

