/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CheckSignature
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckSignature.class);
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);
    private boolean requireSignature;

    public CheckSignature(boolean signatureRequired) {
        this.requireSignature = signatureRequired;
    }

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        MessageContext inboundMessageContext = profileRequestContext.getInboundMessageContext();
        Envelope envelope = (Envelope)inboundMessageContext.getMessage();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)inboundMessageContext));
        Header header = envelope.getHeader();
        if (header == null) {
            this.log.error("Action {}: Header was not found from the envelope!", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        List objects = header.getUnknownXMLObjects(Security.ELEMENT_NAME);
        if (objects.size() != 1) {
            this.log.debug("Action {}: No or more than one security elements in the header!", (Object)this.getId());
            throw new InvalidSignatureException("More than one security elements in the header!");
        }
        Security security = (Security)objects.get(0);
        if ((objects = security.getUnknownXMLObjects(Signature.DEFAULT_ELEMENT_NAME)).size() == 0) {
            if (this.requireSignature) {
                this.log.debug("Action {}: No signature element found from the security header, even though it's required!", (Object)this.getId());
                throw new InvalidSignatureException("No signature element found from the security header, even though it's required!");
            }
            this.log.debug("Action {}: No signature element found from the security header, nothing left to do.", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        if (objects.size() > 1) {
            this.log.debug("Action {}: More than one signature elements in the security header!", (Object)this.getId());
            throw new InvalidSignatureException("More than one signature elements in the security header!");
        }
        RSAPublicKey publicKey = SoapActionSupport.getPublicKeyFromEnvelope(this, envelope);
        if (!this.signatureValidated((Signature)objects.get(0), (Credential)new BasicCredential((PublicKey)publicKey), tokenRequestContext.getId())) {
            this.log.debug("Action {}: Could not validate the signature", (Object)this.getId());
            throw new InvalidSignatureException("Could not validate the signature in " + tokenRequestContext.getId());
        }
        this.log.debug("Action {}: Signature was valid!", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected boolean signatureValidated(Signature signature, Credential validatingCredential, String messageId) {
        SignatureValidator validator = new SignatureValidator(validatingCredential);
        try {
            validator.validate(signature);
        }
        catch (SignatureException e) {
            this.log.warn("Action {}: The signature could not be validated for {}", (Object)this.getId(), (Object)messageId);
            this.log.debug("Action {}: The stack for the failure", (Object)this.getId(), (Object)e);
            return false;
        }
        return true;
    }

    public static class InvalidSignatureException
    extends ProfileException {
        private static final long serialVersionUID = -367932432432124555L;

        public InvalidSignatureException(String message) {
            super(message);
        }
    }
}

