/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckRequestType
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckRequestType.class);
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)messageContext));
        String requestType = tokenRequestContext.getAction();
        if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue".equals(requestType)) {
            this.log.debug("Action {}: Ignoring an {} operation request.", (Object)this.getId(), (Object)requestType);
            throw new UnSupportedWsTrustRequestTypeException(requestType);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class UnSupportedWsTrustRequestTypeException
    extends ProfileException {
        private static final long serialVersionUID = -7078373199423732050L;

        public UnSupportedWsTrustRequestTypeException(String wrongType) {
            super("Request type '" + wrongType + "' is not supported!");
        }
    }
}

