/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CheckMessageId
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckMessageId.class);
    private boolean requireId;
    private Function<MessageContext<Envelope>, BasicMessageMetadataContext> messageMetadataContextLookupStrategy;

    public CheckMessageId(boolean idRequired) {
        this.requireId = idRequired;
        this.messageMetadataContextLookupStrategy = new ChildContextLookup(BasicMessageMetadataContext.class, false);
    }

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Checking for the message ID in the incoming message", (Object)this.getId());
        BasicMessageMetadataContext messageSubcontext = (BasicMessageMetadataContext)this.messageMetadataContextLookupStrategy.apply((Object)profileRequestContext.getInboundMessageContext());
        if (messageSubcontext.getMessageId() == null && this.requireId) {
            this.log.debug("Action {}: Message ID is not found, even though it's required", (Object)this.getId());
            throw new NoMessageIdFoundException("Message ID is not found, even though it's required");
        }
        this.log.debug("Action {}: Message ID was found, nothing left to do", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class NoMessageIdFoundException
    extends ProfileException {
        private static final long serialVersionUID = -872917446121234555L;

        public NoMessageIdFoundException(String message) {
            super(message);
        }
    }
}

