/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Objects;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.soap.xmlobject.Framework;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidProfileContext")})
public class CheckFrameworkVersion
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckFrameworkVersion.class);
    private boolean requireVersion;

    public CheckFrameworkVersion(boolean forceVersion) {
        this.requireVersion = forceVersion;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        Header header = ((Envelope)profileRequestContext.getInboundMessageContext().getMessage()).getHeader();
        if (header == null) {
            this.log.error("Action {}: Header was not found from the envelope!", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        Framework framework = this.getFrameworkFromEnvelopeHeader(profileRequestContext, header);
        String version = framework.getVersion();
        if (Objects.equal((Object)"2.0", (Object)version)) {
            this.log.debug("Action {}: Framework version check was ok, proceeding to the next event", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        if (this.requireVersion) {
            this.log.debug("Action {}: Invalid Framework version {} detected, generating fault context", (Object)this.getId(), (Object)version);
            throw new InvalidFrameworkVersionException(version);
        }
        this.log.debug("Action {}: Invalid Framework version {} detected, but not forced, nothing left to do.", (Object)this.getId(), (Object)version);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected Framework getFrameworkFromEnvelopeHeader(ProfileRequestContext<Envelope, Object> profileRequestContext, Header header) throws ProfileException {
        List objects = header.getUnknownXMLObjects(Framework.DEFAULT_ELEMENT_NAME);
        if (objects == null || objects.size() == 0 || objects.size() > 1) {
            if (this.requireVersion) {
                throw new ProfileException("Invalid number of Framework -elements found from the SOAP Header!");
            }
            return null;
        }
        return (Framework)objects.get(0);
    }

    public static class InvalidFrameworkVersionException
    extends ProfileException {
        private static final long serialVersionUID = -872917446217634555L;

        public InvalidFrameworkVersionException(String version) {
            super("Invalid version, was " + version + ", expected 2.0!");
        }
    }
}

