/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="UsernamePassword"), @Event(id="SAMLAssertion")})
public class CheckClaims
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckClaims.class);
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);
    private boolean ldapEnabled;

    public CheckClaims(boolean enableLdap) {
        this.ldapEnabled = enableLdap;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)messageContext));
        String claimsDialect = tokenRequestContext.getClaimsDialect();
        if (claimsDialect.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0")) {
            this.log.debug("Action {} UsernamePassword token in the request.", (Object)this.getId());
            if (this.ldapEnabled) {
                return this.generateAuthenticationContextAndProceed(profileRequestContext, (IdentifiableComponent)this, "UsernamePassword");
            }
            this.log.debug("Action {} Ignoring UsernamePassword token in the request, as LDAP is not enabled.", (Object)this.getId());
            throw new UnSupportedIncomingTokenTypeException(claimsDialect);
        }
        if (claimsDialect.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
            this.log.debug("Action {} SAMLAssertion token in the request.", (Object)this.getId());
            return this.generateAuthenticationContextAndProceed(profileRequestContext, (IdentifiableComponent)this, "SAMLAssertion");
        }
        this.log.debug("Action {}: Wrong claims dialect {} in the request.", (Object)this.getId(), (Object)claimsDialect);
        throw new UnSupportedIncomingTokenTypeException(claimsDialect);
    }

    protected org.springframework.webflow.execution.Event generateAuthenticationContextAndProceed(ProfileRequestContext<Envelope, Object> profileRequestContext, @Nonnull IdentifiableComponent source, @Nonnull String eventId) {
        profileRequestContext.addSubcontext(new AuthenticationRequestContext(null, null), true);
        return ActionSupport.buildEvent(source, eventId);
    }

    public static class UnSupportedIncomingTokenTypeException
    extends ProfileException {
        private static final long serialVersionUID = -7078373199425421250L;

        public UnSupportedIncomingTokenTypeException(String wrongType) {
            super("Token type '" + wrongType + "' is not supported as an incoming token!");
        }
    }
}

