/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.apache.xml.security.utils.Base64;
import org.glite.sts.profile.wstrust.WsTrustActionSupport;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.caclient.CAResponse;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.wssecurity.BinarySecurityToken;
import org.opensaml.soap.wssecurity.Reference;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.SecurityTokenReference;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponse;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponseCollection;
import org.opensaml.soap.wstrust.RequestedSecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddX509CertificateToRSTR
extends AbstractProfileAction<Object, Envelope> {
    public static final String URI_ID = "#X509SecurityToken";
    private final Logger log = LoggerFactory.getLogger(AddX509CertificateToRSTR.class);
    private Function<MessageContext<?>, TokenGenerationContext> tokenGenerationContextLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        byte[] x509bytes;
        this.log.debug("Action {}: Attempting to add a certificate to outgoing RSTR inside an Envelope", (Object)this.getId());
        TokenGenerationContext tokenGenerationCtx = (TokenGenerationContext)((Object)this.tokenGenerationContextLookupStrategy.apply((Object)profileRequestContext.getOutboundMessageContext()));
        if (tokenGenerationCtx == null) {
            this.log.debug("Action {}: No TokenGenerationContext available, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        X509TokenGenerationContext x509Context = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)tokenGenerationCtx));
        if (x509Context == null) {
            this.log.debug("Action {}: No X509TokenGenerationContext available for TokenGenerationContext {}, nothing left to do", (Object)this.getId(), (Object)tokenGenerationCtx.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        CAResponse caResponse = x509Context.getCaResponse();
        if (caResponse == null) {
            this.log.debug("Action {}: No CAResponse available in the X509TokenGenerationContext {}, nothing left to do", (Object)this.getId(), (Object)x509Context.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        X509Certificate x509Certificate = caResponse.getCertificate();
        if (x509Certificate == null) {
            this.log.debug("Action {}: No X509Certificate available in the CAResponse, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        try {
            x509bytes = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            this.log.warn("Action {}: Could not encode the certificate into bytes, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        String x509 = new String(Base64.encode((byte[])x509bytes));
        this.log.debug("Pre-requisities fine, now generating the element");
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Envelope was not found from the outbound context.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        RequestSecurityTokenResponseCollection rstrc = (RequestSecurityTokenResponseCollection)envelope.getBody().getUnknownXMLObjects(RequestSecurityTokenResponseCollection.ELEMENT_NAME).get(0);
        RequestSecurityTokenResponse rstr = (RequestSecurityTokenResponse)rstrc.getRequestSecurityTokenResponses().get(0);
        Security securityHeader = (Security)envelope.getHeader().getUnknownXMLObjects(Security.ELEMENT_NAME).get(0);
        RequestedSecurityToken requestedToken = WsTrustActionSupport.addRequestedTokenToRSTR(this, rstr);
        SecurityTokenReference tokenReference = WsTrustActionSupport.addSecurityTokenReferenceToRequestedToken(this, requestedToken);
        Reference reference = WsTrustActionSupport.addReferenceToSecurityTokenReference(this, tokenReference);
        reference.setURI(URI_ID);
        BinarySecurityToken binaryToken = WsTrustActionSupport.addBinarySecurityTokenToSecurityHeader(this, securityHeader);
        binaryToken.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#Base64Binary");
        binaryToken.setWSUId(URI_ID);
        binaryToken.setValue(x509);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

