/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.SoapFaultContext;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.glite.sts.profile.soap.xmlobject.Status;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddFaultToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddFaultToEnvelope.class);
    private Function<ProfileRequestContext<?, ?>, SoapFaultContext> soapFaultContextLookupStrategy = new ChildContextLookup(SoapFaultContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Attempting to add Fault into the body of an envelope", (Object)this.getId());
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Envelope was not found from the outbound context.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        Body body = envelope.getBody();
        SoapFaultContext faultContext = (SoapFaultContext)((Object)this.soapFaultContextLookupStrategy.apply(profileRequestContext));
        Fault fault = SoapActionSupport.addFaultToBody(this, body);
        if (faultContext == null) {
            fault.getCode().setValue(FaultCode.SERVER);
            fault.getMessage().setValue("Internal server error");
        } else {
            fault.getCode().setValue(faultContext.getFaultcode());
            fault.getMessage().setValue(faultContext.getFaultstring());
            if (faultContext.getStatusCode() != null) {
                Status status = SoapActionSupport.addStatusToDetail(this, fault.getDetail());
                status.setCode(faultContext.getStatusCode());
                status.setRef(faultContext.getStatusRef());
                status.setComment(faultContext.getStatusComment());
            }
        }
        this.log.debug("Action {}: All done, proceeding to the next state", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

