/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddActionToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddActionToEnvelope.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Attempting to add Action to the envelope header", (Object)this.getId());
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Envelope was not found from the outbound context.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        Header header = envelope.getHeader();
        Action soapAction = SoapActionSupport.addActionToHeader(this, header);
        soapAction.setValue("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue");
        this.log.debug("Action {}: All done, proceeding to the next state", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

