/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.config;

import java.io.File;
import java.io.IOException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.glite.sts.STSException;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfiguration {
    private final Logger log = LoggerFactory.getLogger(ServerConfiguration.class);
    public static final String CFG_SECTION_MESSAGES = "Messages";
    public static final String CFG_SECTION_CACLIENT = "CAClient";
    public static final String CFG_SECTION_SAML = "SAML";
    public static final String CFG_SECTION_LDAP = "LDAP";
    public static final String CFG_SECTION_VOMS = "VOMS";
    private Ini iniConfiguration;

    public ServerConfiguration(String iniFile) throws STSException {
        this.log.debug("Trying to construct a new configuration from the file {}", (Object)iniFile);
        try {
            this.iniConfiguration = new Ini(new File(iniFile));
        }
        catch (InvalidFileFormatException e) {
            this.log.error("The configuration file {} has an invalid format!", (Object)iniFile);
            throw new STSException("The configuration file has an invalid format!", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.log.error("Could not read the configuration file {}!", (Object)iniFile);
            throw new STSException("Could not read the configuration file!", e);
        }
        this.log.info("Successfully constructed a new configuration from the file {}", (Object)iniFile);
    }

    public String getCAClientConfigurationValue(String key) throws STSException {
        return this.getStringConfigurationValue(CFG_SECTION_CACLIENT, key);
    }

    public String getMessagesConfigurationValue(String key) throws STSException {
        return this.getStringConfigurationValue(CFG_SECTION_MESSAGES, key);
    }

    public String getSamlConfigurationValue(String key) throws STSException {
        return this.getStringConfigurationValue(CFG_SECTION_SAML, key);
    }

    public String getLdapConfigurationValue(String key) throws STSException {
        return this.getStringConfigurationValue(CFG_SECTION_LDAP, key);
    }

    public String getVomsConfigurationValue(String key) throws STSException {
        return this.getStringConfigurationValue(CFG_SECTION_VOMS, key);
    }

    public String getStringConfigurationValue(String sectionId, String key) throws STSException {
        String stringValue = (String)this.getConfigurationSection(sectionId).get((Object)key);
        return StringSupport.trimOrNull((String)stringValue);
    }

    public int getIntConfigurationValue(String sectionId, String key) throws STSException {
        String stringValue = this.getStringConfigurationValue(sectionId, key);
        if (stringValue == null) {
            return -1;
        }
        Integer integer = new Integer(stringValue);
        return integer;
    }

    public long getLongConfigurationValue(String sectionId, String key) throws STSException {
        String stringValue = this.getStringConfigurationValue(sectionId, key);
        if (stringValue == null) {
            return -1L;
        }
        Long longInt = new Long(stringValue);
        return longInt;
    }

    public boolean getBoolConfigurationValue(String sectionId, String key) throws STSException {
        String stringValue = (String)this.getConfigurationSection(sectionId).get((Object)key);
        return stringValue != null && stringValue.equalsIgnoreCase("true");
    }

    public boolean getOppositeBoolConfigurationValue(String sectionId, String key) throws STSException {
        return !this.getBoolConfigurationValue(sectionId, key);
    }

    public Profile.Section getConfigurationSection(String sectionId) throws STSException {
        Profile.Section iniSection = (Profile.Section)this.iniConfiguration.get((Object)sectionId);
        if (iniSection == null) {
            throw new STSException("Could not find a section with id " + sectionId);
        }
        return iniSection;
    }
}

