/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.xml.security.utils.Base64;
import org.glite.sts.authn.UsernamePasswordContext;
import org.ldaptive.BindOperation;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.Credential;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.ConnectionPool;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidProfileContext")})
public class ValidateUsernamePasswordAgainstLdap
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstLdap.class);
    public static final String DEFAULT_UID_ATTRIBUTE = "uid";
    public static final String DEFAULT_PASSWORD_ATTRIBUTE = "userPassword";
    private Function<AuthenticationRequestContext, UsernamePasswordContext> usernameCtxLookupStrategy = new ChildContextLookup(UsernamePasswordContext.class, false);
    private ConnectionPool ldapConnectionPool;
    private String ldapBaseDn;
    private String ldapBindDn;
    private Credential ldapBindCredential;
    private String ldapPasswordAttributeName;
    private String ldapUidAttributeName;
    private String ldapHashAlgorithm;

    public ValidateUsernamePasswordAgainstLdap(ConnectionPool connectionPool, String baseDn) {
        this(connectionPool, baseDn, null, null, DEFAULT_UID_ATTRIBUTE, DEFAULT_PASSWORD_ATTRIBUTE, null);
    }

    public ValidateUsernamePasswordAgainstLdap(ConnectionPool connectionPool, String baseDn, String bindDn, String bindCredential) {
        this(connectionPool, baseDn, bindDn, bindCredential, DEFAULT_UID_ATTRIBUTE, DEFAULT_PASSWORD_ATTRIBUTE, null);
    }

    public ValidateUsernamePasswordAgainstLdap(ConnectionPool connectionPool, String baseDn, String bindDn, String bindCredential, String uid, String password, String hashAlgorithm) {
        this.ldapConnectionPool = (ConnectionPool)Constraint.isNotNull((Object)connectionPool, (String)"LDAP connection pool cannot be null!");
        this.ldapBaseDn = (String)Constraint.isNotNull((Object)baseDn, (String)"Base DN cannot be null!");
        this.ldapBindDn = bindDn;
        this.ldapBindCredential = bindCredential != null ? new Credential(bindCredential) : null;
        this.ldapUidAttributeName = (String)Constraint.isNotNull((Object)uid, (String)"LDAP uid attribute cannot be null!");
        this.ldapPasswordAttributeName = (String)Constraint.isNotNull((Object)password, (String)"LDAP password attribute cannot be null!");
        this.ldapHashAlgorithm = hashAlgorithm;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        UsernamePasswordContext usernameContext = (UsernamePasswordContext)((Object)this.usernameCtxLookupStrategy.apply((Object)authenticationContext));
        if (usernameContext == null) {
            this.log.debug("Action {}: No UsernamePasswordContext found, nothing left to do.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        String username = usernameContext.getUsername();
        return this.logResultAndGo(this.ldapSearchAndCompare(usernameContext), username);
    }

    protected org.springframework.webflow.execution.Event logResultAndGo(boolean successful, String username) throws AuthenticationException {
        if (successful) {
            this.log.debug("Action {}: Successfully authenticated {}", (Object)this.getId(), (Object)username);
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        this.log.debug("Action {}: Could not authenticate {}", (Object)this.getId(), (Object)username);
        throw new InvalidUsernamePasswordException(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ldapSearchAndCompare(UsernamePasswordContext usernameContext) {
        LdapEntry entry;
        block12: {
            Credential bindCredential;
            String bindDn;
            Connection conn;
            String username = usernameContext.getUsername();
            try {
                conn = this.ldapConnectionPool.getConnection();
            }
            catch (LdapException e) {
                this.log.error("Action {}: Could not get a connection from the pool!", (Object)this.getId());
                this.log.debug("Caused by", (Throwable)e);
                return false;
            }
            if (this.ldapBindDn == null) {
                bindDn = this.ldapUidAttributeName + "=" + username + "," + this.ldapBaseDn;
                if (usernameContext.isPasswordHashed()) {
                    this.log.warn("Incoming password is hashed, ldapBindDn must be configured in order to authenticate the user!");
                    return false;
                }
                bindCredential = new Credential(usernameContext.getPassword());
            } else {
                bindDn = this.ldapBindDn;
                bindCredential = this.ldapBindCredential;
            }
            try {
                conn.open();
                BindOperation bind = new BindOperation(conn);
                this.log.debug("Action {}: Attempting to authenticate {}", (Object)this.getId(), (Object)bindDn);
                bind.execute((Request)new BindRequest(bindDn, bindCredential));
                if (this.ldapBindDn != null) {
                    SearchOperation search = new SearchOperation(conn);
                    SearchRequest req = new SearchRequest(this.ldapBaseDn, "(uid=" + username + ")");
                    SearchResult result = (SearchResult)search.execute((Request)req).getResult();
                    entry = result.getEntry();
                    break block12;
                }
                this.log.debug("Action {}: BIND operation was successful, user is authenticated.", (Object)this.getId());
                boolean bl = true;
                return bl;
            }
            catch (LdapException e) {
                this.log.debug("Action {}: Could not access the LDAP directory: {}", (Object)this.getId(), (Object)e.getMessage());
                this.log.debug("Caused by", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                conn.close();
            }
        }
        if (entry == null) {
            return false;
        }
        return this.validatePassword(entry.getAttribute(this.ldapPasswordAttributeName), usernameContext);
    }

    protected boolean validatePassword(LdapAttribute ldapPassword, UsernamePasswordContext usernameContext) {
        String storedPassword = ldapPassword.getStringValue();
        String givenPassword = usernameContext.getPassword();
        if (this.ldapHashAlgorithm == null) {
            return givenPassword.equals(storedPassword);
        }
        if (this.ldapHashAlgorithm.equalsIgnoreCase("sha1")) {
            String hashedPassword;
            try {
                hashedPassword = ValidateUsernamePasswordAgainstLdap.calculateHash(givenPassword);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("Could not use the SHA1 algorithm", (Throwable)e);
                return false;
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 not supported in the platform!", (Throwable)e);
                return false;
            }
            return hashedPassword.equals(storedPassword);
        }
        this.log.error("Unsupported hashing algorithm configured: {}", (Object)this.ldapHashAlgorithm);
        return false;
    }

    public static String calculateHash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("UTF-8"), 0, text.length());
        sha1hash = md.digest();
        return Base64.encode((byte[])sha1hash);
    }

    public class InvalidUsernamePasswordException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183235438L;

        public InvalidUsernamePasswordException(String username) {
            super("The password for " + username + " was invalid.");
        }
    }
}

