/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.authn.AssertionContext;
import org.glite.sts.saml.idstore.AuthnRequestIdManager;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckAssertionSubjectConfirmation
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(CheckAssertionSubjectConfirmation.class);
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> rpContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    private String consumerServiceUrl;
    AuthnRequestIdManager authnRequestIdManager;

    public CheckAssertionSubjectConfirmation(String consumerServiceUrl, boolean checkInResponse, AuthnRequestIdManager authnIdManager) {
        this.consumerServiceUrl = consumerServiceUrl;
        this.authnRequestIdManager = checkInResponse ? (AuthnRequestIdManager)Constraint.isNotNull((Object)authnIdManager, (String)"Authentication request id manager cannot be null if response-to check is required!") : null;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        Assertion assertion = ((AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authenticationContext))).getAssertion();
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.rpContextLookupStrategy.apply((Object)profileRequestContext));
        Subject subject = assertion.getSubject();
        if (subject == null) {
            this.log.debug("Action {}: Subject was not found from the assertion!", (Object)this.getId());
            throw new InvalidSubjectConfirmationException("Subject is not found inside the assertion!");
        }
        List subjectConfirmations = assertion.getSubject().getSubjectConfirmations();
        if (subjectConfirmations != null) {
            for (int i = 0; i < subjectConfirmations.size(); ++i) {
                if (this.verifySubjectConfirmation((SubjectConfirmation)subjectConfirmations.get(i), relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getClockSkew())) {
                    this.log.debug("Action {}: SubjectConfirmation supported and validated, nothing left to do.", (Object)this.getId());
                    return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
                }
                this.log.debug("Action {}: Ignored a non-supported SubjectConfirmation", (Object)this.getId());
            }
        }
        throw new InvalidSubjectConfirmationException("Could not find any supported SubjectConfirmations");
    }

    protected boolean verifySubjectConfirmation(SubjectConfirmation subjectConfirmation, long clockSkew) throws AuthenticationException {
        SubjectConfirmationData confirmationData;
        if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod()) && (confirmationData = subjectConfirmation.getSubjectConfirmationData()) != null) {
            this.log.debug("Action {}: A valid bearer confirmation method was found.", (Object)this.getId());
            long currentTime = System.currentTimeMillis();
            long expirationTime = confirmationData.getNotOnOrAfter().getMillis();
            if (currentTime - clockSkew > expirationTime) {
                this.log.debug("Action {}: A bearer method was found, but it was expired.", (Object)this.getId());
                throw new InvalidSubjectConfirmationException(expirationTime);
            }
            String recipient = confirmationData.getRecipient();
            if (this.consumerServiceUrl != null && recipient != null && !this.consumerServiceUrl.equals(recipient)) {
                this.log.debug("Action {}: This subject confirmation is not targeted to the STS", (Object)this.getId());
                throw new InvalidSubjectConfirmationException("This subject confirmation is not targeted to this STS");
            }
            if (this.authnRequestIdManager != null) {
                this.log.debug("Action {}: Authentication request id must be found from the local storage", (Object)this.getId());
                if (!this.authnRequestIdManager.isAuthnRequestIdValid(confirmationData.getInResponseTo())) {
                    this.log.debug("Action {}: Authentication request id was not found from the local storage", (Object)this.getId());
                    throw new InvalidSubjectConfirmationException("Initial authentication request from the STS was not found or is expired");
                }
            }
            return true;
        }
        return false;
    }

    public class InvalidSubjectConfirmationException
    extends AuthenticationException {
        private static final long serialVersionUID = 6432112310183231233L;

        public InvalidSubjectConfirmationException(String message) {
            super(message);
        }

        public InvalidSubjectConfirmationException(long expirationTime) {
            super("Valid confirmation method was found, but it was expired on " + new DateTime(expirationTime).toString());
        }
    }
}

