/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.glite.sts.authn.AssertionContext;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckAssertionAuthnStatement
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(CheckAssertionAuthnStatement.class);
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> rpContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    private long authenticationLifetime;
    private boolean requireStatement;
    private boolean requireLocalityMatch;
    private String proxyHeaderKey;

    public CheckAssertionAuthnStatement(long authnLifetime, boolean statementRequired, boolean localityRequired, String proxyHeader) {
        this.authenticationLifetime = authnLifetime;
        this.requireStatement = statementRequired;
        this.requireLocalityMatch = localityRequired;
        this.proxyHeaderKey = proxyHeader;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        Assertion assertion = ((AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authenticationContext))).getAssertion();
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.rpContextLookupStrategy.apply((Object)profileRequestContext));
        List statements = assertion.getAuthnStatements();
        if (this.requireStatement && statements.size() != 1) {
            this.log.debug("Action {}: Invalid number of authentication statements {}", (Object)this.getId(), (Object)statements.size());
            throw new NoSingleAuthnStatementInAssertionException(statements.size());
        }
        AuthnStatement statement = (AuthnStatement)statements.get(0);
        if (this.requireLocalityMatch) {
            this.verifyLocality(httpRequest, statement.getSubjectLocality());
        }
        this.verifyAuthnInstant(statement.getAuthnInstant().getMillis(), relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getClockSkew());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected void verifyLocality(HttpServletRequest httpRequest, SubjectLocality locality) throws AuthenticationException {
        String remoteIp;
        String localityIp = locality.getAddress();
        if (StringSupport.trimOrNull((String)this.proxyHeaderKey) == null) {
            remoteIp = httpRequest.getRemoteAddr();
        } else {
            this.log.debug("Trying to resolve the remote IP address from the header {}", (Object)this.proxyHeaderKey);
            remoteIp = httpRequest.getHeader(this.proxyHeaderKey);
            if (remoteIp == null) {
                this.log.error("Could not resolve the remote address from the header {}", (Object)this.proxyHeaderKey);
                throw new InvalidRemoteAddressInAssertionException("Could not resolve the remote address");
            }
        }
        this.log.debug("Action {}: Comparing locality address {} vs. remote address {}", new Object[]{this.getId(), localityIp, remoteIp});
        if (!remoteIp.equals(localityIp)) {
            this.log.warn("Action {}: IP addresses did not match even though they are required, remote address {}", (Object)this.getId(), (Object)remoteIp);
            throw new InvalidRemoteAddressInAssertionException(localityIp, remoteIp);
        }
    }

    protected void verifyAuthnInstant(long issueInstant, long clockskew) throws AuthenticationException {
        long currentTime = System.currentTimeMillis();
        if (issueInstant + this.authenticationLifetime < currentTime - clockskew) {
            this.log.debug("Action {}: Issue instant has been expired", (Object)this.getId());
            throw new PastAuthnInstantInAssertionException(issueInstant);
        }
        if (issueInstant > currentTime + clockskew) {
            this.log.debug("Action {}: Issue instant is in the too far future", (Object)this.getId());
            throw new FutureAuthnInstantInAssertionException(issueInstant);
        }
    }

    public class FutureAuthnInstantInAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 3232111987544135763L;

        public FutureAuthnInstantInAssertionException(long instant) {
            super("Authentication instant is in the future: " + new DateTime(instant) + " and cannot be accepted.");
        }
    }

    public class PastAuthnInstantInAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 3232111231232135763L;

        public PastAuthnInstantInAssertionException(long instant) {
            super("Authentication instant is too far in the past: " + new DateTime(instant) + " and cannot be accepted.");
        }
    }

    public class InvalidRemoteAddressInAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 3232111231234341233L;

        public InvalidRemoteAddressInAssertionException(String message) {
            super(message);
        }

        public InvalidRemoteAddressInAssertionException(String localityIp, String remoteIp) {
            super("Invalid SubjectLocality (" + localityIp + ") in AuthnStatement, remote address is " + remoteIp);
        }
    }

    public class NoSingleAuthnStatementInAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6432111231234341233L;

        public NoSingleAuthnStatementInAssertionException(int amount) {
            super("No single AuthnStatement found in the assertion, there were: " + amount + " of them.");
        }
    }
}

