/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.AuthenticationEvent;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;

@ThreadSafe
public final class ServiceSession
extends BaseContext {
    private final String serviceId;
    private final long creationInstant;
    private long lastActivityInstant;
    private AuthenticationEvent authenticationEvent;

    public ServiceSession(@Nonnull @NotEmpty String id, @Nonnull AuthenticationEvent event) {
        this.serviceId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Service ID can not be null nor empty");
        this.lastActivityInstant = this.creationInstant = System.currentTimeMillis();
        this.authenticationEvent = (AuthenticationEvent)((Object)Constraint.isNotNull((Object)((Object)event), (String)"Authentication event can not be null"));
    }

    @Nonnull
    @NotEmpty
    public String getServiceId() {
        return this.serviceId;
    }

    public long getCreationInstant() {
        return this.creationInstant;
    }

    public long getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(long instant) {
        this.lastActivityInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Last activity instant must be greater than 0");
    }

    public void setLastActivityInstantToNow() {
        this.lastActivityInstant = System.currentTimeMillis();
    }

    @Nonnull
    public AuthenticationEvent getAuthenticationEvent() {
        return this.authenticationEvent;
    }

    public void setAuthenticationEvent(@Nonnull AuthenticationEvent event) {
        this.authenticationEvent = (AuthenticationEvent)((Object)Constraint.isNotNull((Object)((Object)event), (String)"Authentication event can not be null"));
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServiceSession) {
            return Objects.equal((Object)this.serviceId, (Object)((ServiceSession)((Object)obj)).getServiceId());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("serviceId", (Object)this.serviceId).add("creationInstant", (Object)new DateTime(this.creationInstant)).add("lastActivityInstant", this.lastActivityInstant).add("authenticationEvent", (Object)this.authenticationEvent).toString();
    }
}

