/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.AuthenticationEvent;
import net.shibboleth.idp.session.ServiceSession;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;

@ThreadSafe
public final class IdPSession
extends BaseContext
implements IdentifiableComponent {
    public static final String MDC_ATTRIBUTE = "idp.session.id";
    private final String id;
    private final byte[] secret;
    private final long creationInstant;
    private long lastActivityInstant;
    private final ConcurrentMap<String, AuthenticationEvent> authenticationEvents;
    private final ConcurrentMap<String, ServiceSession> serviceSessions;
    private final Lock authnServiceStateLock = new ReentrantLock();

    public IdPSession(@Nonnull @NotEmpty String sessionId, @Nonnull byte[] sessionSecret) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sessionId), (String)"Session ID can not be null or empty");
        Constraint.isNotNull((Object)sessionSecret, (String)"Session secret can not be null");
        this.secret = new byte[sessionSecret.length];
        System.arraycopy(sessionSecret, 0, this.secret, 0, sessionSecret.length);
        this.lastActivityInstant = this.creationInstant = System.currentTimeMillis();
        this.authenticationEvents = new ConcurrentHashMap<String, AuthenticationEvent>(5);
        this.serviceSessions = new ConcurrentHashMap<String, ServiceSession>(10);
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nonnull
    public byte[] getSecret() {
        return this.secret;
    }

    public long getCreationInstant() {
        return this.creationInstant;
    }

    public long getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(long instant) {
        this.lastActivityInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Last activity instant must be greater than 0");
    }

    public void setLastActivityInstantToNow() {
        this.lastActivityInstant = System.currentTimeMillis();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<AuthenticationEvent> getAuthenticateEvents() {
        return new HashSet<AuthenticationEvent>(this.authenticationEvents.values());
    }

    @Nonnull
    public Optional<AuthenticationEvent> getAuthenticationEvent(@Nullable String workflowId) {
        String trimmedId = StringSupport.trimOrNull((String)workflowId);
        if (trimmedId == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(this.authenticationEvents.get(trimmedId));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<ServiceSession> getServiceSessions() {
        return new HashSet<ServiceSession>(this.serviceSessions.values());
    }

    @Nonnull
    public Optional<ServiceSession> getServiceSession(@Nullable String serviceId) {
        String trimmedId = StringSupport.trimOrNull((String)serviceId);
        if (trimmedId == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(this.serviceSessions.get(trimmedId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceSession(@Nonnull ServiceSession session) {
        Constraint.isNotNull((Object)((Object)session), (String)"Service session can not be null");
        String serviceId = session.getServiceId();
        try {
            this.authnServiceStateLock.lock();
            Constraint.isFalse((boolean)this.serviceSessions.containsKey(session.getId()), (String)("A session for service " + serviceId + " already exists"));
            AuthenticationEvent authnEvent = session.getAuthenticationEvent();
            if (!this.authenticationEvents.containsKey(authnEvent.getAuthenticationWorkflow())) {
                this.authenticationEvents.put(authnEvent.getAuthenticationWorkflow(), authnEvent);
            }
            this.serviceSessions.put(serviceId, session);
        }
        finally {
            this.authnServiceStateLock.unlock();
        }
    }

    public boolean removeServiceSession(@Nonnull ServiceSession session) {
        Constraint.isNotNull((Object)((Object)session), (String)"Service session can not be null");
        return this.serviceSessions.remove(session.getServiceId(), (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationEvent(@Nonnull AuthenticationEvent event) {
        Constraint.isNotNull((Object)((Object)event), (String)"Authentication event can not be null");
        try {
            this.authnServiceStateLock.lock();
            for (ServiceSession session : this.serviceSessions.values()) {
                if (!session.getAuthenticationEvent().equals((Object)event)) continue;
                throw new IllegalStateException("Authentication event " + event.getAuthenticationWorkflow() + " is associated with the session for service " + session.getServiceId() + " and so can not be removed");
            }
            this.authenticationEvents.remove(event.getAuthenticationWorkflow(), (Object)event);
        }
        finally {
            this.authnServiceStateLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof IdPSession) {
            return Objects.equal((Object)this.getId(), (Object)((IdPSession)((Object)obj)).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("sessionId", (Object)this.id).add("creatingInstant", (Object)new DateTime(this.creationInstant)).add("lastActivityInstant", (Object)new DateTime(this.lastActivityInstant)).add("authenticationEvents", this.getAuthenticateEvents()).add("serviceSessions", this.getServiceSessions()).toString();
    }
}

