/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class RelyingPartyConfiguration {
    private final String id;
    private final String responderEntityId;
    private final Map<String, ProfileConfiguration> profileConfigurations;

    public RelyingPartyConfiguration(@Nonnull @NotEmpty String configurationId, @Nonnull @NotEmpty String responderId, @Nullable @NullableElements Collection<? extends ProfileConfiguration> configurations) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)configurationId), (String)"Relying party configuration ID can not be null or empty");
        this.responderEntityId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)responderId), (String)"Responder entity ID can not be null");
        if (configurations == null || configurations.isEmpty()) {
            this.profileConfigurations = Collections.emptyMap();
            return;
        }
        ImmutableMap.Builder configBuilder = new ImmutableMap.Builder();
        for (ProfileConfiguration profileConfiguration : configurations) {
            if (profileConfiguration == null) continue;
            String trimmedId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)profileConfiguration.getProfileId()), (String)("ID of profile configuration class " + profileConfiguration.getClass().getName() + " can not be null"));
            configBuilder.put((Object)trimmedId, (Object)profileConfiguration);
        }
        this.profileConfigurations = configBuilder.build();
    }

    @Nonnull
    @NotEmpty
    public String getConfigurationId() {
        return this.id;
    }

    @Nonnull
    @NotEmpty
    public String getResponderEntityId() {
        return this.responderEntityId;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable String profileId) {
        String trimmedId = StringSupport.trimOrNull((String)profileId);
        if (trimmedId == null) {
            return null;
        }
        return this.profileConfigurations.get(trimmedId);
    }
}

