/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.HttpServletRequestMessageDecoderFactory;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="UnableToDecode", description="An error occured trying to decode the message")})
public class DecodeMessage
extends AbstractProfileAction {
    public static final String UNABLE_TO_DECODE = "UnableToDecode";
    private final Logger log = LoggerFactory.getLogger(DecodeMessage.class);
    private final HttpServletRequestMessageDecoderFactory decoderFactory;

    public DecodeMessage(@Nonnull HttpServletRequestMessageDecoderFactory factory) {
        this.decoderFactory = (HttpServletRequestMessageDecoderFactory)Constraint.isNotNull((Object)factory, (String)"Message decoder factory can not be null");
    }

    protected org.springframework.webflow.execution.Event doExecute(@Nonnull HttpServletRequest httpRequest, @Nullable HttpServletResponse httpResponse, @Nullable RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) throws ProfileException {
        try {
            MessageDecoder decoder = this.decoderFactory.newDecoder(httpRequest);
            this.log.debug("Action {}: Using message decoder of type {} for this request", (Object)this.getId(), (Object)decoder.getClass().getName());
            this.log.debug("Action {}: Decoding incoming request", (Object)this.getId());
            decoder.decode();
            MessageContext msgContext = decoder.getMessageContext();
            decoder.destroy();
            this.log.debug("Action {}: Incoming request decoded into a message context of type {}", (Object)this.getId(), (Object)msgContext.getClass().getName());
            profileRequestContext.setInboundMessageContext(msgContext);
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        catch (MessageDecodingException e) {
            this.log.debug("Action {}: Unable to decode incoming request", (Object)this.getId(), (Object)e);
            return ActionSupport.buildEvent((IdentifiableComponent)this, UNABLE_TO_DECODE);
        }
    }
}

