/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.concurrent.TimeUnit;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SecurityConfiguration {
    private final long clockSkew;
    private final IdentifierGenerationStrategy idGenerator;
    private SignatureValidationConfiguration sigValidateConfig;
    private SignatureSigningConfiguration sigSigningConfig;
    private DecryptionConfiguration decryptConfig;
    private EncryptionConfiguration encryptConfig;

    public SecurityConfiguration() {
        this.clockSkew = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        this.idGenerator = new RandomIdentifierGenerationStrategy();
    }

    public SecurityConfiguration(int skew, IdentifierGenerationStrategy generator) {
        this.clockSkew = (int)Constraint.isGreaterThan((long)0L, (long)skew, (String)"Clock skew must be greater than 0");
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Identifier generator can not be null");
    }

    public long getClockSkew() {
        return this.clockSkew;
    }

    public IdentifierGenerationStrategy getIdGenerator() {
        return this.idGenerator;
    }

    public SignatureValidationConfiguration getSignatureValidationConfiguration() {
        return this.sigValidateConfig;
    }

    public void setSignatureValidationConfiguration(SignatureValidationConfiguration config) {
        this.sigValidateConfig = config;
    }

    public SignatureSigningConfiguration getSignatureSigningConfiguration() {
        return this.sigSigningConfig;
    }

    public void setSignatureSigningConfiguration(SignatureSigningConfiguration config) {
        this.sigSigningConfig = config;
    }

    public DecryptionConfiguration getDecryptionConfiguration() {
        return this.decryptConfig;
    }

    public void setDecryptionConfiguration(DecryptionConfiguration config) {
        this.decryptConfig = config;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptConfig;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration config) {
        this.encryptConfig = config;
    }
}

