/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import com.google.common.base.Objects;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractProfileConfiguration
implements ProfileConfiguration {
    private final String id;
    private boolean enabled;
    private SecurityConfiguration securityConfiguration;

    public AbstractProfileConfiguration(String profileId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)profileId), (String)"Profile identifier can not be null or empty");
        this.enabled = true;
    }

    @Override
    public String getProfileId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @Override
    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(SecurityConfiguration configuration) {
        this.securityConfiguration = configuration;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equal((Object)this.id, (Object)other.getProfileId());
    }
}

