/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.Attribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public class AttributeContext
extends BaseContext {
    private Map<String, Attribute> attributes = Collections.emptyMap();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable @NullableElements Collection<Attribute> newAttributes) {
        if (newAttributes == null) {
            this.attributes = Collections.emptyMap();
            return;
        }
        HashMap<String, Attribute> checkedAttributes = new HashMap<String, Attribute>();
        for (Attribute attribute : newAttributes) {
            if (attribute == null) continue;
            checkedAttributes.put(attribute.getId(), attribute);
        }
        this.attributes = ImmutableMap.copyOf(checkedAttributes);
    }
}

