/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Constraint;
import com.google.common.collect.Constraints;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@NotThreadSafe
public class Attribute
implements Comparable<Attribute>,
Cloneable {
    private final String id;
    private Map<Locale, String> displayNames;
    private Map<Locale, String> displayDescriptions;
    private Set<AttributeValue> values;
    private Set<AttributeEncoder<?>> encoders;

    public Attribute(@Nonnull @NotEmpty String attributeId) {
        this.id = (String)net.shibboleth.utilities.java.support.logic.Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID may not be null");
        this.displayNames = Collections.emptyMap();
        this.displayDescriptions = Collections.emptyMap();
        this.values = Constraints.constrainedSet(new HashSet(), (Constraint)Constraints.notNull());
        this.encoders = Collections.emptySet();
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    private Map<Locale, String> checkedNamesFrom(@Nullable @NullableElements Map<Locale, String> inputMap) {
        HashMap<Locale, String> checkedMap = new HashMap<Locale, String>();
        if (inputMap != null) {
            for (Map.Entry<Locale, String> entry : inputMap.entrySet()) {
                String trimmedName;
                if (entry.getKey() == null || (trimmedName = StringSupport.trimOrNull((String)entry.getValue())) == null) continue;
                checkedMap.put(entry.getKey(), trimmedName);
            }
        }
        return ImmutableMap.copyOf(checkedMap);
    }

    public void setDisplayNames(@Nullable @NullableElements Map<Locale, String> newNames) {
        this.displayNames = this.checkedNamesFrom(newNames);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayDescriptions() {
        return this.displayDescriptions;
    }

    public void setDisplayDescriptions(@Nullable @NullableElements Map<Locale, String> newDescriptions) {
        this.displayDescriptions = this.checkedNamesFrom(newDescriptions);
    }

    @Nonnull
    @NonnullElements
    public Set<AttributeValue> getValues() {
        return this.values;
    }

    public void setValues(@Nullable @NullableElements Collection<AttributeValue> newValues) {
        Set checkedValues = Constraints.constrainedSet(new HashSet(), (Constraint)Constraints.notNull());
        CollectionSupport.addIf((Collection)checkedValues, newValues, (Predicate)Predicates.notNull());
        this.values = checkedValues;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Set<AttributeEncoder<?>> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(@Nullable @NullableElements Collection<AttributeEncoder<?>> newEncoders) {
        HashSet checkedEncoders = new HashSet();
        CollectionSupport.addIf(checkedEncoders, newEncoders, (Predicate)Predicates.notNull());
        this.encoders = ImmutableSet.copyOf(checkedEncoders);
    }

    @Override
    public int compareTo(Attribute other) {
        return this.getId().compareTo(other.getId());
    }

    @Nonnull
    public Attribute clone() throws CloneNotSupportedException {
        Attribute clone = (Attribute)super.clone();
        clone.setDisplayDescriptions(this.getDisplayDescriptions());
        clone.setDisplayNames(this.getDisplayNames());
        clone.setEncoders(this.getEncoders());
        clone.setValues(this.getValues());
        return clone;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equal((Object)this.id, (Object)other.getId());
    }

    @Nonnull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("displayNames", this.displayNames).add("displayDescriptions", this.displayDescriptions).add("encoders", this.encoders).add("values", this.values).toString();
    }
}

