/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.encoder;

import java.io.OutputStream;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.message.handler.BaseHandlerChainAwareMessageEncoder;
import org.opensaml.ws.transport.OutTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAP11Encoder
extends BaseHandlerChainAwareMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(SOAP11Encoder.class);
    private SOAPObjectBuilder<Envelope> envBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;

    public SOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isConfidential();
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isIntegrityProtected();
    }

    protected void prepareMessageContext(MessageContext messageContext) throws MessageEncodingException {
        if (messageContext.getOutboundMessage() == null) {
            messageContext.setOutboundMessage((XMLObject)this.buildSOAPEnvelope(messageContext));
        }
    }

    protected void encodeToTransport(MessageContext messageContext) throws MessageEncodingException {
        Element envelopeElem = this.marshallMessage(messageContext.getOutboundMessage());
        this.preprocessTransport(messageContext);
        OutTransport outTransport = messageContext.getOutboundMessageTransport();
        SerializeSupport.writeNode((Node)envelopeElem, (OutputStream)outTransport.getOutgoingStream());
    }

    protected void preprocessTransport(MessageContext messageContext) throws MessageEncodingException {
    }

    protected Envelope buildSOAPEnvelope(MessageContext messageContext) {
        this.log.debug("Building SOAP envelope");
        Envelope envelope = (Envelope)this.envBuilder.buildObject();
        Body body = (Body)this.bodyBuilder.buildObject();
        envelope.setBody(body);
        return envelope;
    }
}

