/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.X509KeyManager;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;

public class X509KeyManagerX509CredentialAdapter
extends AbstractCredential
implements X509Credential {
    private String credentialAlias;
    private X509KeyManager keyManager;

    public X509KeyManagerX509CredentialAdapter(X509KeyManager manager, String alias) {
        this.keyManager = (X509KeyManager)Constraint.isNotNull((Object)manager, (String)"Key manager may not be null");
        this.credentialAlias = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alias), (String)"Entity alias may not be null");
    }

    public Collection<X509CRL> getCRLs() {
        return Collections.EMPTY_LIST;
    }

    public X509Certificate getEntityCertificate() {
        X509Certificate[] certs = this.keyManager.getCertificateChain(this.credentialAlias);
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        X509Certificate[] certs = this.keyManager.getCertificateChain(this.credentialAlias);
        if (certs != null && certs.length > 0) {
            return Arrays.asList(certs);
        }
        return null;
    }

    public PrivateKey getPrivateKey() {
        return this.keyManager.getPrivateKey(this.credentialAlias);
    }

    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }

    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    public void setEntityId(String newEntityID) {
        super.setEntityId(newEntityID);
    }

    public void setUsageType(UsageType newUsageType) {
        super.setUsageType(newUsageType);
    }
}

