/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;

public class StaticPKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    private List<PKIXValidationInformation> pkixInfo;
    private Set<String> trustedNames;

    public StaticPKIXValidationInformationResolver(List<PKIXValidationInformation> info, Set<String> names) {
        this.pkixInfo = info != null ? new ArrayList<PKIXValidationInformation>(info) : Collections.EMPTY_LIST;
        this.trustedNames = names != null ? new HashSet<String>(names) : Collections.EMPTY_SET;
    }

    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws ResolverException, UnsupportedOperationException {
        return this.trustedNames;
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    public Iterable<PKIXValidationInformation> resolve(CriteriaSet criteria) throws ResolverException {
        return this.pkixInfo;
    }

    public PKIXValidationInformation resolveSingle(CriteriaSet criteria) throws ResolverException {
        if (!this.pkixInfo.isEmpty()) {
            return this.pkixInfo.get(0);
        }
        return null;
    }
}

