/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509SubjectKeyIdentifierCriterion;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509SubjectKeyIdentifierCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509SubjectKeyIdentifierCredentialCriterion.class);
    private byte[] ski;

    public EvaluableX509SubjectKeyIdentifierCredentialCriterion(X509SubjectKeyIdentifierCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.ski = criteria.getSubjectKeyIdentifier();
    }

    public EvaluableX509SubjectKeyIdentifierCredentialCriterion(byte[] newSKI) {
        if (newSKI == null || newSKI.length == 0) {
            throw new IllegalArgumentException("Subject key identifier may not be null or empty");
        }
        this.ski = newSKI;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy subject key identifier criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, does not satisfy criteria");
            return Boolean.FALSE;
        }
        byte[] credSKI = X509Support.getSubjectKeyIdentifier((X509Certificate)entityCert);
        if (credSKI == null || credSKI.length == 0) {
            this.log.info("Could not evaluate criteria, certificate contained no subject key identifier extension");
            return null;
        }
        Boolean result = Arrays.equals(this.ski, credSKI);
        return result;
    }
}

