/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509CertSelectorCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509CertSelectorCredentialCriterion.class);
    private X509CertSelector certSelector;

    public EvaluableX509CertSelectorCredentialCriterion(X509CertSelector newSelector) {
        if (newSelector == null) {
            throw new IllegalArgumentException("X509 cert selector may not be null");
        }
        this.certSelector = newSelector;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, can not evaluate X509CertSelector criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, can not evaluate X509CertSelector criteria");
            return Boolean.FALSE;
        }
        Boolean result = this.certSelector.match(entityCert);
        return result;
    }
}

