/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import com.google.common.base.Strings;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.EntityIDCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableEntityIDCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableEntityIDCredentialCriterion.class);
    private String entityID;

    public EvaluableEntityIDCredentialCriterion(EntityIDCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.entityID = criteria.getEntityID();
    }

    public EvaluableEntityIDCredentialCriterion(String newEntityID) {
        if (Strings.isNullOrEmpty((String)newEntityID)) {
            throw new IllegalArgumentException("Entity ID may not be null");
        }
        this.entityID = newEntityID;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (Strings.isNullOrEmpty((String)target.getEntityId())) {
            this.log.info("Could not evaluate criteria, credential contained no entity ID");
            return null;
        }
        Boolean result = this.entityID.equals(target.getEntityId());
        return result;
    }
}

