/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto;

import com.google.common.io.Files;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.io.PrivateKeyCredentialReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import org.opensaml.security.SecurityException;
import org.opensaml.security.crypto.SigningUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeySupport {
    private static Map<String, String> keyMatchAlgorithms = new LazyMap();

    private KeySupport() {
    }

    public static Integer getKeyLength(Key key) {
        Logger log = KeySupport.getLogger();
        if (key instanceof SecretKey && "RAW".equals(key.getFormat())) {
            return key.getEncoded().length * 8;
        }
        log.debug("Unable to determine length in bits of specified Key instance");
        return null;
    }

    public static SecretKey decodeSecretKey(byte[] key, char[] password) throws KeyException {
        throw new UnsupportedOperationException("This method is not yet supported");
    }

    public static PublicKey decodePublicKey(byte[] key, char[] password) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
        try {
            return KeySupport.buildKey(keySpec, "RSA");
        }
        catch (KeyException ex) {
            try {
                return KeySupport.buildKey(keySpec, "DSA");
            }
            catch (KeyException ex2) {
                try {
                    return KeySupport.buildKey(keySpec, "EC");
                }
                catch (KeyException keyException) {
                    throw new KeyException("Unsupported key type.");
                }
            }
        }
    }

    public static PrivateKey decodePrivateKey(File key, char[] password) throws KeyException {
        if (!key.exists()) {
            throw new KeyException("Key file " + key.getAbsolutePath() + " does not exist");
        }
        if (!key.canRead()) {
            throw new KeyException("Key file " + key.getAbsolutePath() + " is not readable");
        }
        try {
            return KeySupport.decodePrivateKey(Files.toByteArray((File)key), password);
        }
        catch (IOException e) {
            throw new KeyException("Error reading Key file " + key.getAbsolutePath(), e);
        }
    }

    public static PrivateKey decodePrivateKey(byte[] key, char[] password) throws KeyException {
        PrivateKeyCredentialReader credReader = new PrivateKeyCredentialReader();
        ByteArrayInputStream bais = new ByteArrayInputStream(key);
        try {
            if (password != null && password.length > 0) {
                return credReader.read((InputStream)bais, password);
            }
            return (PrivateKey)credReader.read((InputStream)bais);
        }
        catch (IOException e) {
            throw new KeyException("Unable to decode private key", e);
        }
        catch (CryptException e) {
            throw new KeyException("Unable to decode private key", e);
        }
    }

    public static PublicKey derivePublicKey(PrivateKey key) throws KeyException {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            DSAParams keyParams = dsaKey.getParams();
            BigInteger y = keyParams.getQ().modPow(dsaKey.getX(), keyParams.getP());
            DSAPublicKeySpec pubKeySpec = new DSAPublicKeySpec(y, keyParams.getP(), keyParams.getQ(), keyParams.getG());
            try {
                KeyFactory factory = KeyFactory.getInstance("DSA");
                return factory.generatePublic(pubKeySpec);
            }
            catch (GeneralSecurityException e) {
                throw new KeyException("Unable to derive public key from DSA private key", e);
            }
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(rsaKey.getModulus(), rsaKey.getPublicExponent());
            try {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                return factory.generatePublic(pubKeySpec);
            }
            catch (GeneralSecurityException e) {
                throw new KeyException("Unable to derive public key from RSA private key", e);
            }
        }
        throw new KeyException("Private key was not a DSA or RSA key");
    }

    public static DSAPublicKey buildJavaDSAPublicKey(String base64EncodedKey) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Support.decode((String)base64EncodedKey));
        return (DSAPublicKey)KeySupport.buildKey(keySpec, "DSA");
    }

    public static RSAPublicKey buildJavaRSAPublicKey(String base64EncodedKey) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Support.decode((String)base64EncodedKey));
        return (RSAPublicKey)KeySupport.buildKey(keySpec, "RSA");
    }

    public static ECPublicKey buildJavaECPublicKey(String base64EncodedKey) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Support.decode((String)base64EncodedKey));
        return (ECPublicKey)KeySupport.buildKey(keySpec, "EC");
    }

    public static RSAPrivateKey buildJavaRSAPrivateKey(String base64EncodedKey) throws KeyException {
        PrivateKey key = KeySupport.buildJavaPrivateKey(base64EncodedKey);
        if (!(key instanceof RSAPrivateKey)) {
            throw new KeyException("Generated key was not an RSAPrivateKey instance");
        }
        return (RSAPrivateKey)key;
    }

    public static DSAPrivateKey buildJavaDSAPrivateKey(String base64EncodedKey) throws KeyException {
        PrivateKey key = KeySupport.buildJavaPrivateKey(base64EncodedKey);
        if (!(key instanceof DSAPrivateKey)) {
            throw new KeyException("Generated key was not a DSAPrivateKey instance");
        }
        return (DSAPrivateKey)key;
    }

    public static PrivateKey buildJavaPrivateKey(String base64EncodedKey) throws KeyException {
        return KeySupport.decodePrivateKey(Base64Support.decode((String)base64EncodedKey), null);
    }

    public static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException(keyAlgorithm + "algorithm is not supported by the JCE", e);
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("Invalid key information", e);
        }
    }

    public static SecretKey generateKey(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey key = null;
        KeyGenerator keyGenerator = null;
        keyGenerator = provider != null ? KeyGenerator.getInstance(algo, provider) : KeyGenerator.getInstance(algo);
        keyGenerator.init(keyLength);
        key = keyGenerator.generateKey();
        return key;
    }

    public static KeyPair generateKeyPair(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGenerator = null;
        keyGenerator = provider != null ? KeyPairGenerator.getInstance(algo, provider) : KeyPairGenerator.getInstance(algo);
        keyGenerator.initialize(keyLength);
        return keyGenerator.generateKeyPair();
    }

    public static boolean matchKeyPair(PublicKey pubKey, PrivateKey privKey) throws SecurityException {
        Logger log = KeySupport.getLogger();
        if (pubKey == null || privKey == null) {
            throw new SecurityException("Either public or private key was null");
        }
        String jcaAlgoID = keyMatchAlgorithms.get(privKey.getAlgorithm());
        if (jcaAlgoID == null) {
            throw new SecurityException("Can't determine JCA algorithm ID for key matching from key algorithm: " + privKey.getAlgorithm());
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to match key pair containing key algorithms public '{}' private '{}', using JCA signature algorithm '{}'", new Object[]{pubKey.getAlgorithm(), privKey.getAlgorithm(), jcaAlgoID});
        }
        byte[] data = "This is the data to sign".getBytes();
        byte[] signature = SigningUtil.sign(privKey, jcaAlgoID, data);
        return SigningUtil.verify(pubKey, jcaAlgoID, signature, data);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(KeySupport.class);
    }

    static {
        keyMatchAlgorithms.put("RSA", "SHA1withRSA");
        keyMatchAlgorithms.put("DSA", "SHA1withDSA");
        keyMatchAlgorithms.put("ECDSA", "SHA1withECDSA");
    }
}

