/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;

public abstract class AbstractCredential
implements Credential {
    private String entityId;
    private UsageType usageType;
    private Collection<String> keyNames;
    private PublicKey publicKey;
    private SecretKey secretKey;
    private PrivateKey privateKey;
    private final CredentialContextSet credentialContextSet = new CredentialContextSet();

    public AbstractCredential() {
        this.keyNames = new LazySet();
        this.setUsageType(UsageType.UNSPECIFIED);
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public UsageType getUsageType() {
        return this.usageType;
    }

    @Override
    public Collection<String> getKeyNames() {
        return this.keyNames;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public CredentialContextSet getCredentalContextSet() {
        return this.credentialContextSet;
    }

    protected void setEntityId(String newEntityID) {
        this.entityId = StringSupport.trimOrNull((String)newEntityID);
    }

    protected void setUsageType(UsageType newUsageType) {
        Constraint.isNotNull((Object)((Object)newUsageType), (String)"Credential usage type may not be null");
        this.usageType = newUsageType;
    }

    protected void setPublicKey(PublicKey newPublicKey) {
        Constraint.isNull((Object)this.getSecretKey(), (String)"A credential with a secret key may not contain a public key");
        Constraint.isNotNull((Object)newPublicKey, (String)"Credential public key may not be null");
        this.publicKey = newPublicKey;
    }

    protected void setPrivateKey(PrivateKey newPrivateKey) {
        Constraint.isNull((Object)this.getSecretKey(), (String)"A credential with a secret key may not contain a private key");
        this.privateKey = newPrivateKey;
    }

    protected void setSecretKey(SecretKey newSecretKey) {
        Constraint.isNull((Object)this.getPublicKey(), (String)"A credential with a public key may not contain a secret key");
        Constraint.isNull((Object)this.getPrivateKey(), (String)"A credential with a private key may not contain a secret key");
        Constraint.isNotNull((Object)newSecretKey, (String)"Credential secret key may not be null");
        this.secretKey = newSecretKey;
    }
}

