/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.EncryptedKey;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class PKIArchiveOptions
implements DEREncodable {
    DEREncodable obj;
    int tag;

    public PKIArchiveOptions(DEREncodable obj, int tag) {
        this.obj = obj;
        this.tag = tag;
    }

    public EncryptedKey getEncryptedKey() {
        if (this.tag != 0) {
            return null;
        }
        return (EncryptedKey)this.obj;
    }

    public DEROctetString getKeyGenParameters() {
        if (this.tag != 1) {
            return null;
        }
        return (DEROctetString)this.obj;
    }

    public DERBoolean getArchiveRemGenPrivKey() {
        if (this.tag != 2) {
            return null;
        }
        return (DERBoolean)this.obj;
    }

    public static PKIArchiveOptions getInstance(DERObject obj) {
        return PKIArchiveOptions.getInstance((ASN1TaggedObject)obj, true);
    }

    public static PKIArchiveOptions getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        int tag = tagObj.getTagNo();
        switch (tag) {
            case 0: {
                return new PKIArchiveOptions(EncryptedKey.getInstance((DEREncodable)tagObj.getObject()), 0);
            }
            case 1: {
                return new PKIArchiveOptions((DEREncodable)DEROctetString.getInstance((Object)tagObj.getObject()), 1);
            }
            case 2: {
                return new PKIArchiveOptions((DEREncodable)DERBoolean.getInstance((Object)tagObj.getObject()), 2);
            }
        }
        throw new IllegalArgumentException("unknown tag: " + tag);
    }

    public DERObject getDERObject() {
        return new DERTaggedObject(true, this.tag, this.obj);
    }

    public String toString() {
        return "PKIArchiveOptions: (" + this.obj + ")";
    }
}

