/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Time;

public class OptionalValidity
implements DEREncodable {
    public static final boolean bTimeIsExplicit = true;
    private Time notBefore = null;
    private Time notAfter = null;

    public static OptionalValidity getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OptionalValidity.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static OptionalValidity getInstance(Object obj) {
        if (obj == null) {
            return new OptionalValidity();
        }
        if (obj instanceof OptionalValidity) {
            return (OptionalValidity)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OptionalValidity((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public OptionalValidity(ASN1Sequence seq) {
        Enumeration e;
        Enumeration enumeration = e = seq == null ? null : seq.getObjects();
        block4: while (e != null && e.hasMoreElements()) {
            DERTaggedObject obj = (DERTaggedObject)e.nextElement();
            int tagno = obj == null ? -1 : obj.getTagNo();
            switch (tagno) {
                case 0: {
                    this.notBefore = Time.getInstance((ASN1TaggedObject)obj, (boolean)true);
                    continue block4;
                }
                case 1: {
                    this.notAfter = Time.getInstance((ASN1TaggedObject)obj, (boolean)true);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("invalid asn1 sequence");
        }
    }

    public OptionalValidity() {
    }

    public void setNotBefore(Time notBefore) {
        this.notBefore = notBefore;
    }

    public Time getNotBefore() {
        return this.notBefore;
    }

    public void setNotAfter(Time notAfter) {
        this.notAfter = notAfter;
    }

    public Time getNotAfter() {
        return this.notAfter;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.notBefore != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.notBefore));
        }
        if (this.notAfter != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.notAfter));
        }
        return new DERSequence(v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" (");
        if (this.getNotBefore() != null) {
            sb.append("notBefore: " + this.getNotBefore() + ", ");
        }
        if (this.getNotBefore() != null) {
            sb.append("notAfter: " + this.getNotAfter() + ", ");
        }
        sb.append("hashCode: " + Integer.toHexString(this.hashCode()) + ")");
        return sb.toString();
    }
}

