/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.PKIStatusInfo;
import com.novosec.pkix.asn1.crmf.CertId;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.CertificateList;

public class RevRepContent
implements DEREncodable {
    Vector status = new Vector();
    Vector revCerts = new Vector();
    Vector crls = new Vector();

    public static RevRepContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RevRepContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static RevRepContent getInstance(Object obj) {
        if (obj instanceof RevRepContent) {
            return (RevRepContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RevRepContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public RevRepContent(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        Enumeration estatus = ((ASN1Sequence)e.nextElement()).getObjects();
        while (estatus.hasMoreElements()) {
            this.status.addElement(PKIStatusInfo.getInstance(estatus.nextElement()));
        }
        while (e.hasMoreElements()) {
            DERTaggedObject obj = (DERTaggedObject)e.nextElement();
            switch (obj.getTagNo()) {
                case 0: {
                    Enumeration erevcerts = ((ASN1Sequence)obj.getObject()).getObjects();
                    while (erevcerts.hasMoreElements()) {
                        this.revCerts.addElement(CertId.getInstance(erevcerts.nextElement()));
                    }
                    break;
                }
                case 1: {
                    Enumeration ecrls = ((ASN1Sequence)obj.getObject()).getObjects();
                    while (ecrls.hasMoreElements()) {
                        this.crls.addElement(CertificateList.getInstance(ecrls.nextElement()));
                    }
                    break;
                }
            }
        }
    }

    public RevRepContent(PKIStatusInfo pKIStatusInfo) {
        this.status.clear();
        this.status.addElement(pKIStatusInfo);
        this.revCerts.clear();
        this.crls.clear();
    }

    public void addPKIStatusInfo(PKIStatusInfo pKIStatusInfo) {
        this.status.addElement(pKIStatusInfo);
    }

    public PKIStatusInfo getPKIStatusInfo(int nr) {
        if (this.status.size() > nr) {
            return (PKIStatusInfo)this.status.elementAt(nr);
        }
        return null;
    }

    public void addRevCert(CertId certId) {
        this.revCerts.addElement(certId);
    }

    public CertId getRevCert(int nr) {
        if (this.revCerts.size() > nr) {
            return (CertId)this.revCerts.elementAt(nr);
        }
        return null;
    }

    public void addCrl(CertificateList crl) {
        this.crls.addElement(crl);
    }

    public CertificateList getCrl(int nr) {
        if (this.crls.size() > nr) {
            return (CertificateList)this.crls.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        int i;
        ASN1EncodableVector v = new ASN1EncodableVector();
        ASN1EncodableVector statv = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.status.size(); ++i2) {
            statv.add((DEREncodable)((PKIStatusInfo)this.status.elementAt(i2)));
        }
        v.add((DEREncodable)new DERSequence(statv));
        if (this.revCerts.size() > 0) {
            ASN1EncodableVector revcv = new ASN1EncodableVector();
            for (i = 0; i < this.revCerts.size(); ++i) {
                revcv.add((DEREncodable)((CertId)this.revCerts.elementAt(i)));
            }
            v.add((DEREncodable)new DERSequence(revcv));
        }
        if (this.crls.size() > 0) {
            ASN1EncodableVector crlsv = new ASN1EncodableVector();
            for (i = 0; i < this.crls.size(); ++i) {
                crlsv.add((DEREncodable)((CertificateList)this.crls.elementAt(i)));
            }
            v.add((DEREncodable)new DERSequence(crlsv));
        }
        return new DERSequence(v);
    }

    public String toString() {
        int i;
        String s = "RevRepContent: (";
        if (this.status.size() > 0) {
            s = s + "status: (";
            for (i = 0; i < this.status.size(); ++i) {
                s = s + (PKIStatusInfo)this.status.elementAt(i);
            }
            s = s + "), ";
        }
        if (this.revCerts.size() > 0) {
            s = s + "revCerts: (";
            for (i = 0; i < this.revCerts.size(); ++i) {
                s = s + (CertId)this.revCerts.elementAt(i);
            }
            s = s + "), ";
        }
        if (this.crls.size() > 0) {
            s = s + "crls: (";
            for (i = 0; i < this.crls.size(); ++i) {
                s = s + (CertificateList)this.crls.elementAt(i);
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

