/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.PKIBody;
import com.novosec.pkix.asn1.cmp.PKIHeader;
import com.novosec.pkix.asn1.cmp.ProtectedPart;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class PKIMessage
implements DEREncodable {
    PKIHeader header;
    PKIBody body;
    DERBitString protection;
    Vector extraCerts = new Vector();
    byte[] protectedBytes;

    public static PKIMessage getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIMessage.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKIMessage getInstance(Object obj) {
        if (obj instanceof PKIMessage) {
            return (PKIMessage)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIMessage((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKIMessage(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        DEREncodable derHeader = (DEREncodable)e.nextElement();
        DEREncodable derBody = (DEREncodable)e.nextElement();
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(derHeader);
            v.add(derBody);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream((OutputStream)bao);
            out.writeObject((Object)new DERSequence(v));
            this.protectedBytes = bao.toByteArray();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.header = PKIHeader.getInstance(derHeader);
        this.body = PKIBody.getInstance((DERObject)((ASN1TaggedObject)derBody));
        while (e.hasMoreElements()) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)e.nextElement();
            switch (tagObj.getTagNo()) {
                case 0: {
                    this.protection = DERBitString.getInstance((Object)tagObj.getObject());
                    break;
                }
                case 1: {
                    ASN1Sequence s = (ASN1Sequence)tagObj.getObject();
                    for (int i = 0; i < s.size(); ++i) {
                        this.extraCerts.addElement(X509CertificateStructure.getInstance((Object)s.getObjectAt(i)));
                    }
                    break;
                }
            }
        }
    }

    public PKIMessage(PKIHeader header, PKIBody body) {
        this.header = header;
        this.body = body;
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public void setProtection(DERBitString protection) {
        this.protection = protection;
    }

    public DERBitString getProtection() {
        return this.protection;
    }

    public void addExtraCert(X509CertificateStructure extraCert) {
        this.extraCerts.addElement(extraCert);
    }

    public X509CertificateStructure getExtraCert(int nr) {
        if (this.extraCerts.size() > nr) {
            return (X509CertificateStructure)this.extraCerts.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.header);
        v.add((DEREncodable)this.body);
        if (this.protection != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.protection));
        }
        if (this.extraCerts.size() > 0) {
            ASN1EncodableVector giv = new ASN1EncodableVector();
            for (int i = 0; i < this.extraCerts.size(); ++i) {
                giv.add((DEREncodable)((X509CertificateStructure)this.extraCerts.elementAt(i)));
            }
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)new DERSequence(giv)));
        }
        return new DERSequence(v);
    }

    public byte[] getProtectedBytes() {
        if (this.protectedBytes != null) {
            return this.protectedBytes;
        }
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream((OutputStream)bao);
            out.writeObject((Object)this.getProtectedPart());
            return bao.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ProtectedPart getProtectedPart() {
        return new ProtectedPart(this.header, this.body);
    }

    public String toString() {
        String s = "PKIMessage: ( header: " + this.getHeader() + ", body: " + this.getBody() + ", ";
        if (this.getProtection() != null) {
            s = s + "protection: " + this.getProtection() + ", ";
        }
        if (this.extraCerts.size() > 0) {
            s = s + "extraCerts: (";
            for (int i = 0; i < this.extraCerts.size(); ++i) {
                s = s + this.extraCerts.elementAt(i) + ", ";
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

