/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;

public class InfoTypeAndValue
implements DEREncodable {
    private DERObjectIdentifier infoType;
    private DEREncodable infoValue;

    public static InfoTypeAndValue getInstance(ASN1TaggedObject obj, boolean explicit) {
        return InfoTypeAndValue.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static InfoTypeAndValue getInstance(Object obj) {
        if (obj instanceof InfoTypeAndValue) {
            return (InfoTypeAndValue)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new InfoTypeAndValue((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public InfoTypeAndValue(ASN1Sequence seq) {
        this.infoType = (DERObjectIdentifier)seq.getObjectAt(0);
        this.infoValue = seq.size() == 2 ? seq.getObjectAt(1) : null;
    }

    public InfoTypeAndValue(DERObjectIdentifier infoType) {
        this.infoType = infoType;
    }

    public DERObjectIdentifier getInfoType() {
        return this.infoType;
    }

    public DEREncodable getInfoValue() {
        return this.infoValue;
    }

    public void setInfoValue(DEREncodable infoValue) {
        this.infoValue = infoValue;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.infoType);
        if (this.infoValue != null) {
            v.add(this.infoValue);
        }
        return new DERSequence(v);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InfoTypeAndValue)) {
            return false;
        }
        InfoTypeAndValue other = (InfoTypeAndValue)o;
        if (!this.getInfoType().equals((Object)other.getInfoType())) {
            return false;
        }
        if (this.getInfoValue() == null && other.getInfoValue() == null) {
            return true;
        }
        if (this.getInfoValue() == null || other.getInfoValue() == null) {
            return false;
        }
        ByteArrayOutputStream b1Out = new ByteArrayOutputStream();
        ByteArrayOutputStream b2Out = new ByteArrayOutputStream();
        DEROutputStream d1Out = new DEROutputStream((OutputStream)b1Out);
        DEROutputStream d2Out = new DEROutputStream((OutputStream)b2Out);
        try {
            d1Out.writeObject((Object)this.getInfoValue());
            d2Out.writeObject((Object)other.getInfoValue());
            byte[] b1 = b1Out.toByteArray();
            byte[] b2 = b2Out.toByteArray();
            if (b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i != b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "InfoTypeAndValue: (" + this.getInfoType();
        if (this.getInfoValue() != null) {
            s = s + ", " + this.getInfoValue();
        }
        s = s + ")";
        return s;
    }
}

