/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DHBMParameter
implements DEREncodable {
    AlgorithmIdentifier owf;
    AlgorithmIdentifier mac;

    public static DHBMParameter getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DHBMParameter.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static DHBMParameter getInstance(Object obj) {
        if (obj instanceof DHBMParameter) {
            return (DHBMParameter)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DHBMParameter((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DHBMParameter(ASN1Sequence seq) {
        this.owf = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(0));
        this.mac = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
    }

    public DHBMParameter(AlgorithmIdentifier owf, AlgorithmIdentifier mac) {
        this.owf = owf;
        this.mac = mac;
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.owf);
        v.add((DEREncodable)this.mac);
        return new DERSequence(v);
    }

    public String toString() {
        return "DHBMParameter: (owf = " + this.getOwf() + ", mac = " + this.getMac() + ")";
    }
}

