/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Challenge
implements DEREncodable {
    AlgorithmIdentifier owf;
    DEROctetString witness;
    DEROctetString challenge;

    public static Challenge getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Challenge.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static Challenge getInstance(Object obj) {
        if (obj instanceof Challenge) {
            return (Challenge)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Challenge((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public Challenge(ASN1Sequence seq) {
        int idx = 0;
        DEREncodable obj = seq.getObjectAt(idx);
        if (!(obj instanceof DEROctetString)) {
            this.owf = AlgorithmIdentifier.getInstance((Object)obj);
        }
        int n = ++idx;
        this.witness = (DEROctetString)seq.getObjectAt(n);
        this.challenge = (DEROctetString)seq.getObjectAt(++idx);
    }

    public Challenge(DEROctetString witness, DEROctetString challenge) {
        this.witness = witness;
        this.challenge = challenge;
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public void setOwf(AlgorithmIdentifier owf) {
        this.owf = owf;
    }

    public DEROctetString getWitness() {
        return this.witness;
    }

    public DEROctetString getChallenge() {
        return this.challenge;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.owf != null) {
            v.add((DEREncodable)this.owf);
        }
        v.add((DEREncodable)this.witness);
        v.add((DEREncodable)this.challenge);
        return new DERSequence(v);
    }

    public String toString() {
        String s = "Challenge: (";
        if (this.getOwf() != null) {
            s = s + "owf: " + this.getOwf() + ", ";
        }
        s = s + "witness: " + this.getWitness();
        s = s + "challenge: " + this.getChallenge();
        s = s + ")";
        return s;
    }
}

