/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CertOrEncCert
implements DEREncodable {
    DEREncodable obj;
    int tag;

    public CertOrEncCert(DEREncodable obj, int tag) {
        this.obj = obj;
        this.tag = tag;
    }

    public X509CertificateStructure getCertificate() {
        if (this.tag != 0) {
            return null;
        }
        return (X509CertificateStructure)this.obj;
    }

    public EncryptedValue getEncryptedCert() {
        if (this.tag != 1) {
            return null;
        }
        return (EncryptedValue)this.obj;
    }

    public static CertOrEncCert getInstance(DERObject obj) {
        return CertOrEncCert.getInstance((ASN1TaggedObject)obj, true);
    }

    public static CertOrEncCert getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        int tag = tagObj.getTagNo();
        switch (tag) {
            case 0: {
                return new CertOrEncCert((DEREncodable)X509CertificateStructure.getInstance((Object)tagObj.getObject()), 0);
            }
            case 1: {
                return new CertOrEncCert(EncryptedValue.getInstance(tagObj.getObject()), 1);
            }
        }
        throw new IllegalArgumentException("unknown tag: " + tag);
    }

    public DERObject getDERObject() {
        return new DERTaggedObject(true, this.tag, this.obj);
    }

    public String toString() {
        return "CertOrEncCert: (" + this.obj + ")";
    }
}

