/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.ListView;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

@NotThreadSafe
public class IndexedXMLObjectChildrenList<ElementType extends XMLObject>
extends XMLObjectChildrenList<ElementType> {
    private Map<QName, List<ElementType>> objectIndex = new LazyMap();

    public IndexedXMLObjectChildrenList(XMLObject parent) {
        super(parent);
    }

    public IndexedXMLObjectChildrenList(XMLObject parent, Collection<ElementType> col) {
        super(parent);
        this.addAll(col);
    }

    @Override
    public void add(int index, ElementType element) {
        super.add(index, element);
        this.indexElement(element);
    }

    @Override
    public void clear() {
        super.clear();
        this.objectIndex.clear();
    }

    public List<ElementType> get(QName typeOrName) {
        return this.objectIndex.get(typeOrName);
    }

    protected void indexElement(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.indexElement(type, element);
        }
        this.indexElement(element.getElementQName(), element);
    }

    protected void indexElement(QName index, ElementType element) {
        LazyList objects = this.objectIndex.get(index);
        if (objects == null) {
            objects = new LazyList();
            this.objectIndex.put(index, (List<ElementType>)objects);
        }
        objects.add(element);
    }

    @Override
    public boolean remove(ElementType element) {
        boolean elementRemoved = false;
        elementRemoved = super.remove(element);
        if (elementRemoved) {
            this.removeElementFromIndex(element);
        }
        return elementRemoved;
    }

    @Override
    public ElementType remove(int index) {
        Object returnValue = super.remove(index);
        this.removeElementFromIndex(returnValue);
        return (ElementType)returnValue;
    }

    protected void removeElementFromIndex(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.removeElementFromIndex(type, element);
        }
        this.removeElementFromIndex(element.getElementQName(), element);
    }

    protected void removeElementFromIndex(QName index, ElementType element) {
        List<ElementType> objects = this.objectIndex.get(index);
        if (objects != null) {
            objects.remove(element);
        }
        if (objects.size() == 0) {
            this.objectIndex.remove(index);
        }
    }

    @Override
    public ElementType set(int index, ElementType element) {
        ElementType returnValue = super.set(index, element);
        this.removeElementFromIndex(returnValue);
        this.indexElement(element);
        return returnValue;
    }

    public List<? extends ElementType> subList(QName index) {
        if (!this.objectIndex.containsKey(index)) {
            this.objectIndex.put(index, (List<ElementType>)new LazyList());
        }
        return new ListView(this, index);
    }
}

