/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.io;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.DomTypeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnmarshallerFactory {
    private final Logger log = LoggerFactory.getLogger(UnmarshallerFactory.class);
    private Map<QName, Unmarshaller> unmarshallers = new ConcurrentHashMap<QName, Unmarshaller>();

    public Unmarshaller getUnmarshaller(QName key) {
        if (key == null) {
            return null;
        }
        return this.unmarshallers.get(key);
    }

    public Unmarshaller getUnmarshaller(Element domElement) {
        Unmarshaller unmarshaller = this.getUnmarshaller(DomTypeSupport.getXSIType((Element)domElement));
        if (unmarshaller == null) {
            unmarshaller = this.getUnmarshaller(QNameSupport.getNodeQName((Node)domElement));
        }
        return unmarshaller;
    }

    public Map<QName, Unmarshaller> getUnmarshallers() {
        return Collections.unmodifiableMap(this.unmarshallers);
    }

    public void registerUnmarshaller(QName key, Unmarshaller unmarshaller) {
        this.log.debug("Registering unmarshaller, {}, for object type, {}", (Object)unmarshaller.getClass().getName(), (Object)key);
        if (key == null) {
            throw new IllegalArgumentException("Unmarshaller key may not be null");
        }
        this.unmarshallers.put(key, unmarshaller);
    }

    public Unmarshaller deregisterUnmarshaller(QName key) {
        this.log.debug("Deregistering marshaller for object type {}", (Object)key);
        if (key != null) {
            return this.unmarshallers.remove(key);
        }
        return null;
    }
}

