/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.config;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;

public class XMLObjectProviderRegistrySupport {
    protected XMLObjectProviderRegistrySupport() {
    }

    public static ParserPool getParserPool() {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).getParserPool();
    }

    public static void setParserPool(ParserPool newParserPool) {
        ConfigurationService.get(XMLObjectProviderRegistry.class).setParserPool(newParserPool);
    }

    public static QName getDefaultProviderQName() {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).getDefaultProviderQName();
    }

    public static void registerObjectProvider(QName providerName, XMLObjectBuilder builder, Marshaller marshaller, Unmarshaller unmarshaller) {
        XMLObjectProviderRegistry registry = ConfigurationService.get(XMLObjectProviderRegistry.class);
        registry.getBuilderFactory().registerBuilder(providerName, builder);
        registry.getMarshallerFactory().registerMarshaller(providerName, marshaller);
        registry.getUnmarshallerFactory().registerUnmarshaller(providerName, unmarshaller);
    }

    public static void deregisterObjectProvider(QName key) {
        XMLObjectProviderRegistry registry = ConfigurationService.get(XMLObjectProviderRegistry.class);
        registry.getBuilderFactory().deregisterBuilder(key);
        registry.getMarshallerFactory().deregisterMarshaller(key);
        registry.getUnmarshallerFactory().deregisterUnmarshaller(key);
    }

    public static XMLObjectBuilderFactory getBuilderFactory() {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).getBuilderFactory();
    }

    public static MarshallerFactory getMarshallerFactory() {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).getMarshallerFactory();
    }

    public static UnmarshallerFactory getUnmarshallerFactory() {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).getUnmarshallerFactory();
    }

    public static void registerIDAttribute(QName attributeName) {
        ConfigurationService.get(XMLObjectProviderRegistry.class).registerIDAttribute(attributeName);
    }

    public static void deregisterIDAttribute(QName attributeName) {
        ConfigurationService.get(XMLObjectProviderRegistry.class).deregisterIDAttribute(attributeName);
    }

    public static boolean isIDAttribute(QName attributeName) {
        return ConfigurationService.get(XMLObjectProviderRegistry.class).isIDAttribute(attributeName);
    }
}

