/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config;

import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.opensaml.core.config.Configuration;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.MapBasedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService {
    public static final String DEFAULT_PARTITION_NAME = "default";
    public static final String PROPERTY_PARTITION_NAME = "opensaml.config.partitionName";
    private static ServiceLoader<ConfigurationPropertiesSource> configPropertiesLoader = ServiceLoader.load(ConfigurationPropertiesSource.class);
    private static Configuration configuration;

    protected ConfigurationService() {
    }

    public static <T> T get(Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().get(configClass, partitionName);
    }

    public static <T, I extends T> void register(Class<T> configClass, I configInstance) {
        String partitionName = ConfigurationService.getPartitionName();
        ConfigurationService.getConfiguration().register(configClass, configInstance, partitionName);
    }

    public static <T> T deregister(Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().deregister(configClass, partitionName);
    }

    public static Properties getConfigurationProperties() {
        Logger log = ConfigurationService.getLogger();
        log.trace("Resolving configuration propreties source");
        for (ConfigurationPropertiesSource source : configPropertiesLoader) {
            log.trace("Evaluating configuration properties implementation: {}", (Object)source.getClass().getName());
            Properties props = source.getProperties();
            if (props == null) continue;
            log.trace("Resolved non-null configuration properties using implementation: {}", (Object)source.getClass().getName());
            return props;
        }
        log.trace("Unable to resolve non-null configuration properties from any ConfigurationPropertiesSource");
        return null;
    }

    public static void setConfiguration(Configuration newConfiguration) {
        configuration = newConfiguration;
    }

    protected static String getPartitionName() {
        Logger log = ConfigurationService.getLogger();
        Properties configProperties = ConfigurationService.getConfigurationProperties();
        String partitionName = null;
        partitionName = configProperties != null ? configProperties.getProperty(PROPERTY_PARTITION_NAME, DEFAULT_PARTITION_NAME) : DEFAULT_PARTITION_NAME;
        log.trace("Resolved effective configuration partition name '{}'", (Object)partitionName);
        return partitionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Configuration getConfiguration() {
        if (configuration != null) return configuration;
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            ServiceLoader<Configuration> loader = ServiceLoader.load(Configuration.class);
            Iterator<Configuration> iter = loader.iterator();
            configuration = iter.hasNext() ? iter.next() : new MapBasedConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ConfigurationService.class);
    }
}

