/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.BitString;
import edu.vt.middleware.crypt.x509.types.Reasons;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonFlags
extends BitString {
    public ReasonFlags(byte[] bitString) {
        if (bitString == null) {
            throw new IllegalArgumentException("Bit string cannot be null.");
        }
        if (bitString.length < 1 || bitString.length > 2) {
            throw new IllegalArgumentException("Reason flags must be 1 or 2 bytes long.");
        }
        this.octets = bitString;
    }

    public ReasonFlags(int flags) {
        this.octets = ReasonFlags.getBytes(flags);
    }

    public ReasonFlags(Reasons[] reasons) {
        int flags = 0;
        for (Reasons bit : reasons) {
            flags |= bit.getMask();
        }
        this.octets = ReasonFlags.getBytes(flags);
    }

    public Collection<Reasons> getReasons() {
        ArrayList<Reasons> bits = new ArrayList<Reasons>(Reasons.values().length);
        int intValue = this.intValue();
        for (Reasons bit : Reasons.values()) {
            if ((bit.getMask() & intValue) == 0) continue;
            bits.add(bit);
        }
        return bits;
    }

    public String toString() {
        return this.getReasons().toString();
    }
}

