/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.util.DERHelper;
import edu.vt.middleware.crypt.x509.ExtensionFactory;
import edu.vt.middleware.crypt.x509.ExtensionType;
import edu.vt.middleware.crypt.x509.types.AccessDescriptionList;
import edu.vt.middleware.crypt.x509.types.AuthorityKeyIdentifier;
import edu.vt.middleware.crypt.x509.types.BasicConstraints;
import edu.vt.middleware.crypt.x509.types.DistributionPointList;
import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import edu.vt.middleware.crypt.x509.types.KeyIdentifier;
import edu.vt.middleware.crypt.x509.types.KeyPurposeIdList;
import edu.vt.middleware.crypt.x509.types.KeyUsage;
import edu.vt.middleware.crypt.x509.types.PolicyInformationList;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.DEREncodable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private X509Certificate certificate;

    public ExtensionReader(X509Certificate cert) {
        this.certificate = cert;
    }

    public Object read(String extensionOidOrName) throws CryptException {
        if (extensionOidOrName == null) {
            throw new IllegalArgumentException("extensionOidOrName cannot be null.");
        }
        if (extensionOidOrName.contains(".")) {
            return this.read(ExtensionType.fromOid(extensionOidOrName));
        }
        return this.read(ExtensionType.fromName(extensionOidOrName));
    }

    public Object read(ExtensionType extension) throws CryptException {
        DEREncodable value = this.readObject(extension);
        if (value != null) {
            return ExtensionFactory.createInstance(this.readObject(extension), extension);
        }
        return null;
    }

    public GeneralNameList readSubjectAlternativeName() throws CryptException {
        return ExtensionFactory.createGeneralNameList(this.readObject(ExtensionType.SubjectAlternativeName));
    }

    public GeneralNameList readIssuerAlternativeName() throws CryptException {
        return ExtensionFactory.createGeneralNameList(this.readObject(ExtensionType.IssuerAlternativeName));
    }

    public BasicConstraints readBasicConstraints() throws CryptException {
        return ExtensionFactory.createBasicConstraints(this.readObject(ExtensionType.BasicConstraints));
    }

    public PolicyInformationList readCertificatePolicies() throws CryptException {
        return ExtensionFactory.createPolicyInformationList(this.readObject(ExtensionType.CertificatePolicies));
    }

    public KeyIdentifier readSubjectKeyIdentifier() throws CryptException {
        return ExtensionFactory.createKeyIdentifier(this.readObject(ExtensionType.SubjectKeyIdentifier));
    }

    public AuthorityKeyIdentifier readAuthorityKeyIdentifier() throws CryptException {
        return ExtensionFactory.createAuthorityKeyIdentifier(this.readObject(ExtensionType.AuthorityKeyIdentifier));
    }

    public KeyUsage readKeyUsage() throws CryptException {
        return ExtensionFactory.createKeyUsage(this.readObject(ExtensionType.KeyUsage));
    }

    public KeyPurposeIdList readExtendedKeyUsage() throws CryptException {
        return ExtensionFactory.createKeyPurposeIdList(this.readObject(ExtensionType.ExtendedKeyUsage));
    }

    public DistributionPointList readCRLDistributionPoints() throws CryptException {
        return ExtensionFactory.createDistributionPointList(this.readObject(ExtensionType.CRLDistributionPoints));
    }

    public AccessDescriptionList readAuthorityInformationAccess() throws CryptException {
        return ExtensionFactory.createAccessDescriptionList(this.readObject(ExtensionType.AuthorityInformationAccess));
    }

    public Map<ExtensionType, Object> readAll() throws CryptException {
        HashMap<ExtensionType, Object> extMap = new HashMap<ExtensionType, Object>(ExtensionType.values().length);
        for (ExtensionType type : ExtensionType.values()) {
            Object extension;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading " + (Object)((Object)type)));
            }
            if ((extension = this.read(type)) == null) continue;
            extMap.put(type, extension);
        }
        return extMap;
    }

    private DEREncodable readObject(ExtensionType type) throws CryptException {
        byte[] data = this.certificate.getExtensionValue(type.getOid());
        if (data == null) {
            return null;
        }
        try {
            return DERHelper.toDERObject(data, true);
        }
        catch (IOException e) {
            throw new CryptException("Error reading certificate extension " + (Object)((Object)type), e);
        }
    }
}

