/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.util.Convert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;

public class PemHelper {
    public static final String KEY_ENCRYPTION_ALGORITHM = "AES-256-CBC";
    public static final String HEADER_BEGIN = "-----BEGIN";
    public static final String FOOTER_END = "-----END";
    public static final String PROC_TYPE = "Proc-Type:";
    public static final String DEK_INFO = "DEK-Info:";

    protected PemHelper() {
    }

    public static byte[] decode(byte[] pem) throws IOException {
        return PemHelper.decode(new String(pem, "ASCII"));
    }

    public static byte[] decode(String pem) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(pem));
        ByteBuffer buffer = ByteBuffer.allocateDirect(pem.length() * 3 / 4);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(HEADER_BEGIN) || line.startsWith(FOOTER_END) || line.startsWith(PROC_TYPE) || line.startsWith(DEK_INFO) || line.trim().length() == 0) continue;
            buffer.put(Convert.fromBase64(line));
        }
        buffer.flip();
        byte[] result = new byte[buffer.limit()];
        buffer.get(result);
        return result;
    }

    public static String encodeKey(PublicKey key) throws IOException {
        return PemHelper.encodeObject(key);
    }

    public static PublicKey decodeKey(String pemKey) throws IOException {
        PEMReader reader = new PEMReader((Reader)new StringReader(pemKey));
        PublicKey key = (PublicKey)reader.readObject();
        if (key != null) {
            return key;
        }
        throw new IOException("Error decoding public key.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeKey(PrivateKey key, char[] password, SecureRandom random) throws IOException {
        if (password == null || password.length == 0) {
            return PemHelper.encodeObject(key);
        }
        StringWriter sw = new StringWriter();
        PEMWriter writer = null;
        try {
            writer = new PEMWriter((Writer)sw);
            writer.writeObject((Object)key, KEY_ENCRYPTION_ALGORITHM, password, random);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return sw.toString();
    }

    public static PrivateKey decodeKey(String pemKey, final char[] password) throws IOException {
        PEMReader reader = null;
        reader = password == null || password.length == 0 ? new PEMReader((Reader)new StringReader(pemKey)) : new PEMReader((Reader)new StringReader(pemKey), new PasswordFinder(){

            public char[] getPassword() {
                return password;
            }
        });
        KeyPair keyPair = (KeyPair)reader.readObject();
        if (keyPair != null) {
            return keyPair.getPrivate();
        }
        throw new IOException("Error decoding private key.");
    }

    public static String encodeCert(Certificate key) throws IOException {
        return PemHelper.encodeObject(key);
    }

    public static Certificate decodeCert(String pemCert) throws IOException {
        PEMReader reader = new PEMReader((Reader)new StringReader(pemCert));
        Certificate cert = (Certificate)reader.readObject();
        if (cert != null) {
            return cert;
        }
        throw new IOException("Error decoding certificate.");
    }

    public static boolean isPem(byte[] data) {
        boolean result = true;
        try {
            String start = new String(data, 0, 10, "ASCII");
            if (start.startsWith(HEADER_BEGIN) || start.startsWith(PROC_TYPE)) {
                return true;
            }
            int lineLength = 64;
            for (int i = 0; i < 64 && result; ++i) {
                result = PemHelper.isBase64Char(data[i]);
                if (i <= 61) continue;
                result |= data[i] == 61;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("YIKES! ASCII encoding not supported.");
        }
        return result;
    }

    public static boolean isBase64Char(byte b) {
        return b >= 47 && b <= 122 && (b <= 57 || b >= 65) && (b <= 90 || b >= 97) || b == 43;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeObject(Object o) throws IOException {
        StringWriter sw = new StringWriter();
        PEMWriter writer = null;
        try {
            writer = new PEMWriter((Writer)sw);
            writer.writeObject(o);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return sw.toString();
    }
}

